/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerunit.junit4;

import com.github.dockerunit.core.ServiceContext;
import com.github.dockerunit.core.discovery.DiscoveryProvider;
import com.github.dockerunit.core.discovery.DiscoveryProviderFactory;
import com.github.dockerunit.core.internal.ServiceContextBuilder;
import com.github.dockerunit.core.internal.ServiceContextBuilderFactory;
import com.github.dockerunit.core.internal.UsageDescriptor;
import com.github.dockerunit.core.internal.reflect.DependencyDescriptorBuilderFactory;
import com.github.dockerunit.core.internal.reflect.UsageDescriptorBuilder;
import com.github.dockerunit.internal.lifecycle.InvokeDockerUnitMethod;
import com.github.dockerunit.junit4.lifecycle.DockerUnitAfter;
import com.github.dockerunit.junit4.lifecycle.DockerUnitAfterClass;
import com.github.dockerunit.junit4.lifecycle.DockerUnitBefore;
import com.github.dockerunit.junit4.lifecycle.DockerUnitBeforeClass;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import org.junit.Test;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class DockerUnitRunner
extends BlockJUnit4ClassRunner {
    private final Map<FrameworkMethod, ServiceContext> methodsContexts = new HashMap<FrameworkMethod, ServiceContext>();
    private ServiceContext classContext;
    private ServiceContext discoveryContext;
    private final UsageDescriptorBuilder descriptorBuilder = DependencyDescriptorBuilderFactory.create();
    private final ServiceContextBuilder contextBuilder = ServiceContextBuilderFactory.create();
    private final DiscoveryProvider discoveryProvider;
    private static final Logger logger = Logger.getLogger(DockerUnitRunner.class.getSimpleName());

    public DockerUnitRunner(Class<?> klass) throws InitializationError {
        super(klass);
        ServiceLoader<DiscoveryProviderFactory> loader = ServiceLoader.load(DiscoveryProviderFactory.class);
        ArrayList implementations = new ArrayList();
        loader.forEach(impl -> {
            logger.info("Found discovery provider factory of type " + impl.getClass().getSimpleName());
            implementations.add(impl);
        });
        if (implementations.size() <= 0) {
            throw new InitializationError("No discovery provider factory found. Aborting test.");
        }
        logger.info("Using discovery provider factory " + ((DiscoveryProviderFactory)implementations.get(0)).getClass().getSimpleName());
        this.discoveryProvider = ((DiscoveryProviderFactory)implementations.get(0)).getProvider();
    }

    protected Statement methodInvoker(FrameworkMethod method, Object test) {
        return new InvokeDockerUnitMethod(method, test, this);
    }

    protected void validateTestMethods(List<Throwable> errors) {
        this.validatePublicVoidNoOrServiceContextArgMethods(Test.class, false, errors);
    }

    protected Statement withAfters(FrameworkMethod method, Object target, Statement statement) {
        DockerUnitAfter next = new DockerUnitAfter(method, this, statement, this.discoveryProvider, this.contextBuilder);
        return super.withAfters(method, target, (Statement)next);
    }

    protected Statement withAfterClasses(Statement statement) {
        DockerUnitAfterClass next = new DockerUnitAfterClass(this, statement, this.discoveryProvider, this.contextBuilder);
        return super.withAfterClasses((Statement)next);
    }

    protected Statement withBeforeClasses(Statement statement) {
        Statement next = super.withBeforeClasses(statement);
        UsageDescriptor descriptor = this.descriptorBuilder.buildDescriptor(this.getTestClass().getJavaClass());
        UsageDescriptor discoveryProviderDescriptor = this.descriptorBuilder.buildDescriptor(this.discoveryProvider.getDiscoveryConfig());
        return new DockerUnitBeforeClass(this, next, this.discoveryProvider, this.contextBuilder, descriptor, discoveryProviderDescriptor);
    }

    protected Statement withBefores(FrameworkMethod method, Object target, Statement statement) {
        Statement next = super.withBefores(method, target, statement);
        UsageDescriptor descriptor = this.descriptorBuilder.buildDescriptor(method.getMethod());
        return new DockerUnitBefore(method, this, next, this.discoveryProvider, this.contextBuilder, descriptor);
    }

    protected void validatePublicVoidNoOrServiceContextArgMethods(Class<? extends Annotation> annotation, boolean isStatic, List<Throwable> errors) {
        List methods = this.getTestClass().getAnnotatedMethods(annotation);
        for (FrameworkMethod eachTestMethod : methods) {
            eachTestMethod.validatePublicVoid(isStatic, errors);
            this.validateNoOrOneServiceContextArg(eachTestMethod, errors);
        }
    }

    private void validateNoOrOneServiceContextArg(FrameworkMethod testMethod, List<Throwable> errors) {
        if (testMethod.getMethod().getParameterCount() > 0 && !testMethod.getMethod().getParameterTypes()[0].isAssignableFrom(ServiceContext.class)) {
            errors.add(new Exception("Test method " + testMethod.getName() + "() must have either zero args or one arg of type " + ServiceContext.class.getName()));
        }
    }

    public void setContext(FrameworkMethod method, ServiceContext context) {
        this.methodsContexts.put(method, context);
    }

    public ServiceContext getContext(FrameworkMethod method) {
        return this.methodsContexts.get(method);
    }

    public void setClassContext(ServiceContext context) {
        this.classContext = context;
    }

    public ServiceContext getClassContext() {
        return this.classContext;
    }

    public ServiceContext getDiscoveryContext() {
        return this.discoveryContext;
    }

    public void setDiscoveryContext(ServiceContext discoveryContext) {
        this.discoveryContext = discoveryContext;
    }
}

