/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerunit.junit4.lifecycle;

import com.github.dockerunit.core.ServiceContext;
import com.github.dockerunit.core.discovery.DiscoveryProvider;
import com.github.dockerunit.core.internal.ServiceContextBuilder;
import com.github.dockerunit.core.internal.service.DefaultServiceContext;
import com.github.dockerunit.junit4.DockerUnitRunner;
import java.util.HashSet;
import org.junit.runners.model.Statement;

public class DockerUnitAfterClass
extends Statement {
    private final DockerUnitRunner runner;
    private final Statement statement;
    private final DiscoveryProvider discoveryProvider;
    private final ServiceContextBuilder contextBuilder;

    public void evaluate() throws Throwable {
        try {
            this.statement.evaluate();
        }
        finally {
            ServiceContext discoveryContext;
            ServiceContext context = this.runner.getClassContext();
            if (context != null) {
                ServiceContext cleared = this.contextBuilder.clearContext(context);
                this.discoveryProvider.clearRegistry(cleared, (ServiceContext)new DefaultServiceContext(new HashSet()));
            }
            if ((discoveryContext = this.runner.getDiscoveryContext()) != null) {
                this.contextBuilder.clearContext(discoveryContext);
            }
        }
    }

    public DockerUnitAfterClass(DockerUnitRunner runner, Statement statement, DiscoveryProvider discoveryProvider, ServiceContextBuilder contextBuilder) {
        this.runner = runner;
        this.statement = statement;
        this.discoveryProvider = discoveryProvider;
        this.contextBuilder = contextBuilder;
    }
}

