/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerunit.junit4.lifecycle;

import com.github.dockerunit.core.ServiceContext;
import com.github.dockerunit.core.ServiceInstance;
import com.github.dockerunit.core.discovery.DiscoveryProvider;
import com.github.dockerunit.core.internal.ServiceContextBuilder;
import com.github.dockerunit.core.internal.UsageDescriptor;
import com.github.dockerunit.core.internal.service.DefaultServiceContext;
import com.github.dockerunit.junit4.DockerUnitRunner;
import com.github.dockerunit.junit4.lifecycle.DockerUnitSetup;
import java.util.HashSet;
import org.junit.runners.model.Statement;

public class DockerUnitBeforeClass
extends Statement {
    private final DockerUnitRunner runner;
    private final Statement next;
    private final DiscoveryProvider discoveryProvider;
    private final ServiceContextBuilder contextBuilder;
    private final UsageDescriptor descriptor;
    private final UsageDescriptor discoveryProviderDescriptor;

    public void evaluate() throws Throwable {
        ServiceContext discoveryContext = this.contextBuilder.buildContext(this.discoveryProviderDescriptor);
        this.runner.setDiscoveryContext(discoveryContext);
        if (!discoveryContext.checkStatus(ServiceInstance.Status.STARTED)) {
            throw new RuntimeException(discoveryContext.getFormattedErrors());
        }
        ServiceContext context = new DockerUnitSetup(this.contextBuilder, this.discoveryProvider).setup(this.descriptor);
        if (context == null) {
            context = new DefaultServiceContext(new HashSet());
        }
        this.runner.setClassContext(context);
        if (!context.checkStatus(ServiceInstance.Status.DISCOVERED)) {
            throw new RuntimeException(context.getFormattedErrors());
        }
        this.next.evaluate();
    }

    public DockerUnitBeforeClass(DockerUnitRunner runner, Statement next, DiscoveryProvider discoveryProvider, ServiceContextBuilder contextBuilder, UsageDescriptor descriptor, UsageDescriptor discoveryProviderDescriptor) {
        this.runner = runner;
        this.next = next;
        this.discoveryProvider = discoveryProvider;
        this.contextBuilder = contextBuilder;
        this.descriptor = descriptor;
        this.discoveryProviderDescriptor = discoveryProviderDescriptor;
    }
}

