/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerunit.junit5.lifecycle;

import com.github.dockerunit.core.Service;
import com.github.dockerunit.core.ServiceContext;
import com.github.dockerunit.core.ServiceInstance;
import com.github.dockerunit.core.discovery.DiscoveryProvider;
import com.github.dockerunit.core.internal.ServiceContextBuilder;
import com.github.dockerunit.core.internal.UsageDescriptor;
import com.github.dockerunit.core.internal.service.DefaultServiceContext;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class DockerUnitSetup {
    private static final Logger logger = Logger.getLogger(DockerUnitSetup.class.getSimpleName());
    private final ServiceContextBuilder contextBuilder;
    private final DiscoveryProvider discoveryProvider;

    public ServiceContext setup(UsageDescriptor descriptor) {
        AtomicBoolean failureOccured = new AtomicBoolean(false);
        List<ServiceContext> serviceContexts = descriptor.getUsages().stream().map(arg_0 -> ((ServiceContextBuilder)this.contextBuilder).buildServiceContext(arg_0)).map(ctx -> {
            if (!ctx.checkStatus(ServiceInstance.Status.STARTED)) {
                failureOccured.set(true);
            }
            return ctx;
        }).map(ctx -> {
            if (failureOccured.get()) {
                logger.info("Skipping discovery of svc " + this.getServiceName((ServiceContext)ctx) + " due to a previous failure.");
                return this.abortService((ServiceContext)ctx);
            }
            logger.info("Performing discovery for svc " + this.getServiceName((ServiceContext)ctx));
            ServiceContext postDiscoveryCtx = this.discoveryProvider.populateRegistry(ctx);
            if (!postDiscoveryCtx.checkStatus(ServiceInstance.Status.DISCOVERED)) {
                failureOccured.set(true);
            }
            return postDiscoveryCtx;
        }).collect(Collectors.toList());
        ServiceContext completeContext = this.mergeContexts(serviceContexts);
        return completeContext;
    }

    private String getServiceName(ServiceContext ctx) {
        return ((Service)ctx.getServices().stream().findFirst().get()).getName();
    }

    private ServiceContext abortService(ServiceContext ctx) {
        return new DefaultServiceContext(ctx.getServices().stream().map(svc -> svc.withInstances(this.abortInstances((Service)svc))).collect(Collectors.toSet()));
    }

    private Set<ServiceInstance> abortInstances(Service svc) {
        return svc.getInstances().stream().map(si -> this.ensureStatus((ServiceInstance)si, ServiceInstance.Status.ABORTED, "Aborted due to previous failure.")).collect(Collectors.toSet());
    }

    private ServiceInstance ensureStatus(ServiceInstance si, ServiceInstance.Status status, String statusDetails) {
        return si.hasStatus(status) ? si : si.withStatus(status).withStatusDetails(statusDetails);
    }

    private ServiceContext mergeContexts(List<ServiceContext> serviceContexts) {
        ServiceContext completeContext = null;
        if (!serviceContexts.isEmpty()) {
            completeContext = serviceContexts.remove(0);
        }
        for (ServiceContext serviceContext : serviceContexts) {
            completeContext = completeContext.merge(serviceContext);
        }
        return completeContext;
    }

    public DockerUnitSetup(ServiceContextBuilder contextBuilder, DiscoveryProvider discoveryProvider) {
        this.contextBuilder = contextBuilder;
        this.discoveryProvider = discoveryProvider;
    }
}

