/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jbeanbox;

import com.github.drinkjava2.cglib.proxy.MethodProxy;
import com.github.drinkjava2.jbeanbox.BeanBox;
import com.github.drinkjava2.jbeanbox.BeanBoxContext;
import com.github.drinkjava2.jbeanbox.BeanBoxException;
import com.github.drinkjava2.jbeanbox.NameMatchUtil;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

class ProxyBean
implements com.github.drinkjava2.cglib.proxy.MethodInterceptor {
    protected Object[] box_ctx;

    protected ProxyBean(BeanBox box, BeanBoxContext ctx) {
        this.box_ctx = new Object[]{box, ctx};
    }

    @Override
    public Object intercept(Object obj, Method m, Object[] args, MethodProxy mprxy) throws Throwable {
        List<Object> inters;
        ArrayList<Object> allInters = new ArrayList<Object>();
        BeanBox box = (BeanBox)this.box_ctx[0];
        BeanBoxContext ctx = (BeanBoxContext)this.box_ctx[1];
        if (box.getMethodAops() != null && (inters = box.getMethodAops().get(m)) != null && !inters.isEmpty()) {
            allInters.addAll(inters);
        }
        if (box.getAopRules() != null) {
            for (Object[] entry : box.getAopRules()) {
                if (!NameMatchUtil.nameMatch((String)entry[1], m.getName())) continue;
                allInters.add(entry[0]);
            }
        }
        if (ctx.getAopRules() != null) {
            String thisClassName = obj.getClass().getName();
            for (Object[] aops : ctx.getAopRules()) {
                String methodRegex;
                String classReg = (String)aops[1];
                if (!NameMatchUtil.nameMatch(classReg, thisClassName) || !NameMatchUtil.nameMatch(methodRegex = (String)aops[2], m.getName())) continue;
                allInters.add(aops[0]);
            }
        }
        if (allInters.isEmpty()) {
            return mprxy.invokeSuper(obj, args);
        }
        MethodInterceptor inter = (MethodInterceptor)ctx.getBean(allInters.get(0));
        BeanBoxException.assureNotNull(inter, new String[0]);
        return inter.invoke(new MethodInvoc(obj, m, args, mprxy, allInters, ctx, 1));
    }

    public static class MethodInvoc
    implements MethodInvocation {
        private final Object obj;
        private final Method m;
        private final Object[] args;
        private final MethodProxy mprxy;
        private final List<Object> inters;
        private final BeanBoxContext ctx;
        private int count;

        protected MethodInvoc(Object obj, Method m, Object[] args, MethodProxy mprxy, List<Object> inters, BeanBoxContext ctx, int count) {
            this.obj = obj;
            this.m = m;
            this.args = args;
            this.mprxy = mprxy;
            this.inters = inters;
            this.ctx = ctx;
            this.count = count;
        }

        @Override
        public Object proceed() throws Throwable {
            if (this.count <= this.inters.size() - 1) {
                MethodInterceptor inter = (MethodInterceptor)this.ctx.getBean(this.inters.get(this.count));
                return inter.invoke(new MethodInvoc(this.obj, this.m, this.args, this.mprxy, this.inters, this.ctx, this.count + 1));
            }
            return this.mprxy.invokeSuper(this.obj, this.args);
        }

        @Override
        public final Object getThis() {
            return this.obj;
        }

        @Override
        public final AccessibleObject getStaticPart() {
            return this.m;
        }

        @Override
        public final Method getMethod() {
            return this.m;
        }

        @Override
        public final Object[] getArguments() {
            return this.args != null ? this.args : new Object[]{};
        }
    }
}

