/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jbeanbox;

import com.github.drinkjava2.jbeanbox.BeanBoxException;

public interface ValueTranslator {
    public Object translate(String var1, Class<?> var2);

    public static class DefaultValueTranslator
    implements ValueTranslator {
        @Override
        public Object translate(String s, Class<?> type) {
            if (type == null) {
                BeanBoxException.throwEX("ParamTranslator can not translate to 'null' type");
            }
            if (Integer.class.equals(type) || Integer.TYPE.equals(type)) {
                return Integer.parseInt(s);
            }
            if (Long.class.equals(type) || Long.TYPE.equals(type)) {
                return Long.parseLong(s);
            }
            if (Character.class.equals(type) || Character.TYPE.equals(type)) {
                return Character.valueOf(s.charAt(0));
            }
            if (Byte.class.equals(type) || Byte.TYPE.equals(type)) {
                return Byte.parseByte(s);
            }
            if (Boolean.class.equals(type) || Boolean.TYPE.equals(type)) {
                return Boolean.parseBoolean(s);
            }
            if (Double.class.equals(type) || Double.TYPE.equals(type)) {
                return Double.parseDouble(s);
            }
            if (Float.class.equals(type) || Float.TYPE.equals(type)) {
                return Float.valueOf(Float.parseFloat(s));
            }
            if (Short.class.equals(type) || Short.TYPE.equals(type)) {
                return Short.parseShort(s);
            }
            if (String.class.equals(type)) {
                return s;
            }
            return BeanBoxException.throwEX("Unsupported type:" + type);
        }
    }
}

