/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdbpro;

import com.github.drinkjava2.jdbpro.DbRuntimeException;
import com.github.drinkjava2.jdbpro.inline.InlineQueryRunner;
import com.github.drinkjava2.jdbpro.template.TemplateQueryRunner;
import com.github.drinkjava2.jtransactions.ConnectionManager;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;

public class DbPro
extends TemplateQueryRunner {
    public DbPro() {
    }

    public DbPro(DataSource ds) {
        super(ds);
    }

    public DbPro(DataSource ds, ConnectionManager cm) {
        super(ds, cm);
    }

    public static void clearAll() {
        TemplateQueryRunner.clearBind();
        InlineQueryRunner.clearParams();
    }

    public <T> T queryForObject(Connection conn, String sql, Object ... params) throws SQLException {
        return (T)this.query(conn, sql, (ResultSetHandler)new ScalarHandler(1), params);
    }

    public <T> T queryForObject(String sql, Object ... params) throws SQLException {
        return (T)this.query(sql, (ResultSetHandler)new ScalarHandler(1), params);
    }

    public <T> T nQuery(String sql, ResultSetHandler<T> rsh, Object ... params) {
        try {
            return (T)this.query(sql, rsh, params);
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
    }

    public <T> T nQueryForObject(String sql, Object ... params) {
        return this.nQuery(sql, (ResultSetHandler<T>)new ScalarHandler(1), params);
    }

    public int nUpdate(String sql, Object ... params) {
        try {
            return this.update(sql, params);
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
    }

    public <T> T nInsert(String sql, ResultSetHandler<T> rsh, Object ... params) {
        try {
            return (T)this.insert(sql, rsh, params);
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
    }

    public <T> T nInsertBatch(String sql, ResultSetHandler<T> rsh, Object[][] params) {
        try {
            return (T)this.insertBatch(sql, rsh, params);
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
    }

    public int nExecute(String sql, Object ... params) {
        try {
            return this.execute(sql, params);
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
    }

    public <T> List<T> nExecute(String sql, ResultSetHandler<T> rsh, Object ... params) {
        try {
            return this.execute(sql, rsh, params);
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
    }

    public <T> T iQuery(ResultSetHandler<T> rsh, String ... inlineSQL) {
        try {
            return this.inlineQuery(rsh, inlineSQL);
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
    }

    public <T> T iQueryForObject(String ... inlineSQL) {
        return this.iQuery((ResultSetHandler<T>)new ScalarHandler(1), inlineSQL);
    }

    public int iUpdate(String ... inlineSQL) {
        try {
            return this.inlineUpdate(inlineSQL);
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
    }

    public <T> T iInsert(ResultSetHandler<T> rsh, String ... inlineSQL) {
        try {
            return this.inlineInsert(rsh, inlineSQL);
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
    }

    public int iExecute(String ... inlineSQL) {
        try {
            return this.inlineExecute(inlineSQL);
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
    }

    public <T> List<T> iExecute(ResultSetHandler<T> rsh, String ... inlineSQL) {
        try {
            return this.inlineExecute(rsh, inlineSQL);
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
    }

    public <T> T tQuery(ResultSetHandler<T> rsh, String ... templateSQL) {
        try {
            return this.templateQuery(rsh, templateSQL);
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
    }

    public <T> T tQueryForObject(String ... templateSQL) {
        return this.tQuery((ResultSetHandler<T>)new ScalarHandler(), templateSQL);
    }

    public int tUpdate(String ... templateSQL) {
        try {
            return this.templateUpdate(templateSQL);
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
    }

    public <T> T tInsert(ResultSetHandler<T> rsh, String ... templateSQL) {
        try {
            return this.templateInsert(rsh, templateSQL);
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
    }

    public int tExecute(String ... templateSQL) {
        try {
            return this.templateExecute(templateSQL);
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
    }

    public <T> List<T> tExecute(ResultSetHandler<T> rsh, String ... templateSQL) {
        try {
            return this.templateExecute(rsh, templateSQL);
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
    }
}

