/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdbpro.improve;

import com.github.drinkjava2.jdbpro.DbProLogger;
import com.github.drinkjava2.jtransactions.ConnectionManager;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import javax.sql.DataSource;
import org.apache.commons.dbutils.QueryRunner;

public class ImprovedQueryRunner
extends QueryRunner {
    protected ConnectionManager cm;
    protected Boolean allowShowSQL = false;
    private static final DbProLogger staticlogger = DbProLogger.getLog(ImprovedQueryRunner.class);
    protected DbProLogger logger = staticlogger;

    public ImprovedQueryRunner() {
    }

    public ImprovedQueryRunner(DataSource ds) {
        super(ds);
    }

    public ImprovedQueryRunner(DataSource ds, ConnectionManager cm) {
        super(ds);
        this.cm = cm;
    }

    public void close(Connection conn) throws SQLException {
        if (this.cm == null) {
            super.close(conn);
        } else {
            this.cm.releaseConnection(conn, this.getDataSource());
        }
    }

    public Connection prepareConnection() throws SQLException {
        if (this.cm == null) {
            return super.prepareConnection();
        }
        return this.cm.getConnection(this.getDataSource());
    }

    protected CallableStatement prepareCall(Connection conn, String sql) throws SQLException {
        if (this.getAllowShowSQL().booleanValue()) {
            this.logger.info("SQL: " + sql);
        }
        return super.prepareCall(conn, sql);
    }

    protected PreparedStatement prepareStatement(Connection conn, String sql) throws SQLException {
        if (this.getAllowShowSQL().booleanValue()) {
            this.logger.info(this.formatSql(sql));
        }
        return super.prepareStatement(conn, sql);
    }

    public void fillStatement(PreparedStatement stmt, Object ... params) throws SQLException {
        if (this.getAllowShowSQL().booleanValue()) {
            this.logger.info(this.formatParameters(params));
        }
        super.fillStatement(stmt, params);
    }

    protected String formatSql(String sql) {
        return "SQL: " + sql;
    }

    protected String formatParameters(Object ... params) {
        return "Parameters: " + Arrays.deepToString(params);
    }

    public ConnectionManager getConnectionManager() {
        return this.cm;
    }

    public void setConnectionManager(ConnectionManager connectionManager) {
        this.cm = connectionManager;
    }

    public Boolean getAllowShowSQL() {
        return this.allowShowSQL;
    }

    public void setAllowShowSQL(Boolean allowShowSQL) {
        this.allowShowSQL = allowShowSQL;
    }

    public DbProLogger getLogger() {
        return this.logger;
    }

    public void setLogger(DbProLogger logger) {
        this.logger = logger;
    }
}

