/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdbpro.inline;

import com.github.drinkjava2.jdbpro.DbPro;
import com.github.drinkjava2.jdbpro.DbRuntimeException;
import com.github.drinkjava2.jdbpro.improve.ImprovedQueryRunner;
import com.github.drinkjava2.jdbpro.inline.SqlAndParams;
import com.github.drinkjava2.jtransactions.ConnectionManager;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.dbutils.ResultSetHandler;

public class InlineQueryRunner
extends ImprovedQueryRunner {
    protected static ThreadLocal<ArrayList<Object>> inlineThreadlocalParamCache = new ThreadLocal<ArrayList<Object>>(){

        @Override
        protected ArrayList<Object> initialValue() {
            return new ArrayList<Object>();
        }
    };

    public InlineQueryRunner() {
    }

    public InlineQueryRunner(DataSource ds) {
        super(ds);
    }

    public InlineQueryRunner(DataSource ds, ConnectionManager cm) {
        super(ds, cm);
    }

    protected static void clearParams() {
        inlineThreadlocalParamCache.get().clear();
    }

    public static String param0(Object ... parameters) {
        InlineQueryRunner.clearParams();
        return InlineQueryRunner.param(parameters);
    }

    public static String param(Object ... parameters) {
        for (Object o : parameters) {
            inlineThreadlocalParamCache.get().add(o);
        }
        return "";
    }

    public static String question0(Object ... parameters) {
        InlineQueryRunner.clearParams();
        return InlineQueryRunner.question(parameters);
    }

    public static String question(Object ... parameters) {
        for (Object o : parameters) {
            inlineThreadlocalParamCache.get().add(o);
        }
        return "?";
    }

    public static String valuesQuesions() {
        int howManyQuestionMarks = inlineThreadlocalParamCache.get().size();
        StringBuilder sb = new StringBuilder("values(");
        for (int i = 0; i < howManyQuestionMarks; ++i) {
            if (i != howManyQuestionMarks - 1) {
                sb.append("?,");
                continue;
            }
            sb.append("?");
        }
        sb.append(")");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SqlAndParams inlineToSqlAndParams(String ... inlineSQL) {
        try {
            String sql = null;
            if (inlineSQL != null) {
                StringBuilder sb = new StringBuilder("");
                for (String str : inlineSQL) {
                    sb.append(str);
                }
                sql = sb.toString();
            }
            ArrayList<Object> params = inlineThreadlocalParamCache.get();
            SqlAndParams sp = new SqlAndParams();
            sp.setSql(sql);
            sp.setParams(params.toArray(new Object[params.size()]));
            SqlAndParams sqlAndParams = sp;
            return sqlAndParams;
        }
        finally {
            InlineQueryRunner.clearParams();
        }
    }

    public static String inline(Object bean, String conditionStr, String separatorStr) {
        DbRuntimeException.assertNotNull(bean, "DbProBeanUtils bean can not be null");
        Class<?> beanClass = bean.getClass();
        BeanInfo beanInfo = null;
        PropertyDescriptor[] pds = null;
        try {
            beanInfo = Introspector.getBeanInfo(beanClass);
            pds = beanInfo.getPropertyDescriptors();
        }
        catch (Exception e) {
            throw new DbRuntimeException("DbProBeanUtils  fail to get bean Properties.", e);
        }
        if (pds == null || pds.length < 1) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Object[] params = new Object[pds.length - 1];
        int i = 0;
        for (PropertyDescriptor pd : pds) {
            String fieldName = pd.getName();
            if ("class".equals(fieldName)) continue;
            Method md = pd.getReadMethod();
            try {
                Object value = md.invoke(bean, new Object[0]);
                sb.append(fieldName).append(conditionStr).append(separatorStr);
                params[i++] = value;
            }
            catch (Exception e) {
                throw new DbRuntimeException("DbProBeanUtils fail to get bean Properties.", e);
            }
        }
        sb.setLength(sb.length() - separatorStr.length());
        for (Object param : params) {
            DbPro.param(param);
        }
        return sb.toString();
    }

    public static String inline0(Object bean, String conditionStr, String separatorStr) {
        DbPro.param0(new Object[0]);
        return InlineQueryRunner.inline(bean, conditionStr, separatorStr);
    }

    public <T> T inlineQuery(Connection conn, ResultSetHandler<T> rsh, String ... inlineSQL) throws SQLException {
        SqlAndParams sp = this.inlineToSqlAndParams(inlineSQL);
        return (T)this.query(conn, sp.getSql(), rsh, sp.getParams());
    }

    public <T> T inlineQuery(ResultSetHandler<T> rsh, String ... inlineSQL) throws SQLException {
        SqlAndParams sp = this.inlineToSqlAndParams(inlineSQL);
        return (T)this.query(sp.getSql(), rsh, sp.getParams());
    }

    public int inlineUpdate(Connection conn, String ... inlineSQL) throws SQLException {
        SqlAndParams sp = this.inlineToSqlAndParams(inlineSQL);
        return this.update(conn, sp.getSql(), sp.getParams());
    }

    public int inlineUpdate(String ... inlineSQL) throws SQLException {
        SqlAndParams sp = this.inlineToSqlAndParams(inlineSQL);
        return this.update(sp.getSql(), sp.getParams());
    }

    public <T> T inlineInsert(ResultSetHandler<T> rsh, String ... inlineSQL) throws SQLException {
        SqlAndParams sp = this.inlineToSqlAndParams(inlineSQL);
        return (T)this.insert(sp.getSql(), rsh, sp.getParams());
    }

    public <T> T inlineInsert(Connection conn, ResultSetHandler<T> rsh, String ... inlineSQL) throws SQLException {
        SqlAndParams sp = this.inlineToSqlAndParams(inlineSQL);
        return (T)this.insert(conn, sp.getSql(), rsh, sp.getParams());
    }

    public int inlineExecute(Connection conn, String ... inlineSQL) throws SQLException {
        SqlAndParams sp = this.inlineToSqlAndParams(inlineSQL);
        return this.execute(conn, sp.getSql(), sp.getParams());
    }

    public int inlineExecute(String ... inlineSQL) throws SQLException {
        SqlAndParams sp = this.inlineToSqlAndParams(inlineSQL);
        return this.execute(sp.getSql(), sp.getParams());
    }

    public <T> List<T> inlineExecute(Connection conn, ResultSetHandler<T> rsh, String ... inlineSQL) throws SQLException {
        SqlAndParams sp = this.inlineToSqlAndParams(inlineSQL);
        return this.execute(conn, sp.getSql(), rsh, sp.getParams());
    }

    public <T> List<T> inlineExecute(ResultSetHandler<T> rsh, String ... inlineSQL) throws SQLException {
        SqlAndParams sp = this.inlineToSqlAndParams(inlineSQL);
        return this.execute(sp.getSql(), rsh, sp.getParams());
    }
}

