/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdbpro.template;

import com.github.drinkjava2.jdbpro.inline.SqlAndParams;
import com.github.drinkjava2.jdbpro.template.SqlTemplateEngine;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public class BasicSqlTemplate
implements SqlTemplateEngine {
    private String startDelimiter;
    private String endDelimiter;
    private static final String DIRECT_REPLACE_START_DELIMITER = "${";
    private static final String DIRECT_REPLACE_END_DELIMITER = "}";

    public static final BasicSqlTemplate instance() {
        return InnerBasicSqlTemplate.INSTANCE;
    }

    public BasicSqlTemplate() {
        this.startDelimiter = "#{";
        this.endDelimiter = DIRECT_REPLACE_END_DELIMITER;
    }

    public BasicSqlTemplate(String startDelimiter, String endDelimiter) {
        if (BasicSqlTemplate.isEmpty(startDelimiter) || BasicSqlTemplate.isEmpty(endDelimiter) || startDelimiter.length() > 2 || endDelimiter.length() != 1) {
            throw new BasicSqlTemplateException("BasicSqlTemplate only support startDelimiter has 1 or 2 characters and endDelimiter has 1 character");
        }
        this.startDelimiter = startDelimiter;
        this.endDelimiter = endDelimiter;
    }

    @Override
    public SqlAndParams render(String sqlTemplate, Map<String, Object> paramMap, Set<String> directReplaceNamesSet) {
        return BasicSqlTemplate.doRender(sqlTemplate, paramMap, this.startDelimiter, this.endDelimiter, directReplaceNamesSet);
    }

    protected static SqlAndParams doRender(String template, Map<String, Object> paramMap, String startDelimiter, String endDelimiter, Set<String> directReplaceNamesSet) {
        if (template == null) {
            throw new NullPointerException("Template can not be null");
        }
        StringBuilder sql = new StringBuilder();
        StringBuilder keyNameSB = new StringBuilder();
        ArrayList<Object> paramList = new ArrayList<Object>();
        char[] chars = ("   " + template + "   ").toCharArray();
        int lg = startDelimiter.length();
        char start1 = startDelimiter.charAt(0);
        char start2 = '\u0000';
        if (lg == 2) {
            start2 = startDelimiter.charAt(1);
        }
        char e = endDelimiter.charAt(0);
        int drlg = DIRECT_REPLACE_START_DELIMITER.length();
        char drst1 = DIRECT_REPLACE_START_DELIMITER.charAt(0);
        char drst2 = '\u0000';
        if (drlg == 2) {
            drst2 = DIRECT_REPLACE_START_DELIMITER.charAt(1);
        }
        char eDirect = DIRECT_REPLACE_END_DELIMITER.charAt(0);
        int status = 0;
        boolean directRep = false;
        for (int i = 3; i < chars.length - 2; ++i) {
            char c = chars[i];
            char c1 = chars[i + 1];
            char cm1 = chars[i - 1];
            char cm2 = chars[i - 2];
            if (status == 0 && (lg == 1 && c == start1 || lg == 2 && c == start1 && c1 == start2)) {
                status = 1;
                keyNameSB.setLength(0);
                directRep = false;
            } else if (status == 0 && (drlg == 1 && c == drst1 || drlg == 2 && c == drst1 && c1 == drst2)) {
                status = 1;
                keyNameSB.setLength(0);
                directRep = true;
            } else if (status == 1 && (lg == 1 && cm1 == start1 || lg == 2 && cm2 == start1 && cm1 == start2)) {
                status = 2;
            } else if (status == 1 && (drlg == 1 && cm1 == drst1 || drlg == 2 && cm2 == drst1 && cm1 == drst2)) {
                status = 2;
            } else if (status == 2 && (c == e && !directRep || c == eDirect && directRep)) {
                String key;
                status = 3;
                if (keyNameSB.length() == 0) {
                    BasicSqlTemplate.throwEX("Empty parameter name '" + startDelimiter + endDelimiter + "' found in template: " + template, new Exception[0]);
                }
                if ((key = keyNameSB.toString()).indexOf(46) >= 0) {
                    String beanName = BasicSqlTemplate.substringBefore(key, ".");
                    String propertyName = BasicSqlTemplate.substringAfter(key, ".");
                    if (BasicSqlTemplate.isEmpty(beanName) || BasicSqlTemplate.isEmpty(propertyName)) {
                        BasicSqlTemplate.throwEX("illegal parameter name '" + key + "' found in template: " + template, new Exception[0]);
                    }
                    boolean directReplaceType = BasicSqlTemplate.isDirectReplaceTypeParameter(template, paramMap, directReplaceNamesSet, directRep, beanName);
                    boolean hasValue = paramMap.containsKey(beanName);
                    if (!hasValue) {
                        BasicSqlTemplate.throwEX("Not found bean '" + beanName + "' when render template: " + template, new Exception[0]);
                    }
                    Object bean = paramMap.get(beanName);
                    PropertyDescriptor pd = null;
                    try {
                        pd = new PropertyDescriptor(propertyName, bean.getClass());
                    }
                    catch (IntrospectionException e1) {
                        BasicSqlTemplate.throwEX("IntrospectionException happen when get bean property '" + key + "' in template: " + template, e1);
                    }
                    Method method = pd.getReadMethod();
                    Object beanProperty = null;
                    try {
                        beanProperty = method.invoke(bean, new Object[0]);
                    }
                    catch (Exception e1) {
                        BasicSqlTemplate.throwEX("Exception happen when read bean property '" + key + "' in template: " + template, e1);
                    }
                    if (directReplaceType) {
                        sql.append(beanProperty);
                    } else {
                        sql.append("?");
                        paramList.add(beanProperty);
                    }
                } else {
                    boolean directReplaceType = BasicSqlTemplate.isDirectReplaceTypeParameter(template, paramMap, directReplaceNamesSet, directRep, key);
                    boolean hasValue = paramMap.containsKey(key);
                    if (!hasValue) {
                        BasicSqlTemplate.throwEX("No parameter found for '" + key + "' in template: " + template, new Exception[0]);
                    }
                    if (directReplaceType) {
                        sql.append(paramMap.get(key));
                    } else {
                        sql.append("?");
                        paramList.add(paramMap.get(key));
                    }
                }
                keyNameSB.setLength(0);
            } else if (status == 3 && cm1 == e) {
                status = 0;
            }
            if (status == 0) {
                sql.append(c);
                continue;
            }
            if (status != 2) continue;
            keyNameSB.append(c);
        }
        if (status != 0) {
            BasicSqlTemplate.throwEX("Missing end delimiter '" + endDelimiter + "' in template: " + template, new Exception[0]);
        }
        SqlAndParams sp = new SqlAndParams();
        sql.setLength(sql.length() - 1);
        sp.setSql(sql.toString());
        sp.setParams(paramList.toArray(new Object[paramList.size()]));
        return sp;
    }

    private static boolean isDirectReplaceTypeParameter(String template, Map<String, Object> paramMap, Set<String> directReplaceNamesSet, boolean directRep, String beanName) {
        boolean directReplaceType = BasicSqlTemplate.isDirectReplaceType(beanName, paramMap, directReplaceNamesSet);
        if (directReplaceType && !directRep) {
            BasicSqlTemplate.throwEX("'" + beanName + "' is a SQL parameter, should use put() or put0() method to set SQL parameter, in template: " + template, new Exception[0]);
        }
        if (!directReplaceType && directRep) {
            BasicSqlTemplate.throwEX("'" + beanName + "' is a direct-replace type parameter, should use replace() or replace0() method to put parameter, in template: " + template, new Exception[0]);
        }
        return directReplaceType;
    }

    private static boolean isDirectReplaceType(String keyName, Map<String, Object> paramMap, Set<String> directReplaceNamesSet) {
        if (directReplaceNamesSet == null) {
            return false;
        }
        if (directReplaceNamesSet.contains(keyName)) {
            if (!paramMap.containsKey(keyName)) {
                BasicSqlTemplate.throwEX("'" + keyName + "' is indicated as a direct replace parameter but can not in parameter Map", new Exception[0]);
            }
            return true;
        }
        return false;
    }

    private static void throwEX(String message, Exception ... cause) {
        if (cause != null && cause.length > 0) {
            throw new BasicSqlTemplateException(message, cause[0]);
        }
        throw new BasicSqlTemplateException(message);
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static String substringBefore(String str, String separator) {
        if (BasicSqlTemplate.isEmpty(str) || separator == null) {
            return str;
        }
        if (separator.isEmpty()) {
            return "";
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    public static String substringAfter(String str, String separator) {
        if (BasicSqlTemplate.isEmpty(str)) {
            return str;
        }
        if (separator == null) {
            return "";
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return "";
        }
        return str.substring(pos + separator.length());
    }

    public static class BasicSqlTemplateException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public BasicSqlTemplateException(String msg) {
            super(msg);
        }

        public BasicSqlTemplateException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }

    private static class InnerBasicSqlTemplate {
        private static final BasicSqlTemplate INSTANCE = new BasicSqlTemplate();

        private InnerBasicSqlTemplate() {
        }
    }
}

