/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdbpro.template;

import com.github.drinkjava2.jdbpro.inline.InlineQueryRunner;
import com.github.drinkjava2.jdbpro.inline.SqlAndParams;
import com.github.drinkjava2.jdbpro.template.BasicSqlTemplate;
import com.github.drinkjava2.jdbpro.template.SqlTemplateEngine;
import com.github.drinkjava2.jtransactions.ConnectionManager;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.dbutils.ResultSetHandler;

public class TemplateQueryRunner
extends InlineQueryRunner {
    private SqlTemplateEngine sqlTemplateEngine = BasicSqlTemplate.instance();
    private static ThreadLocal<Map<String, Object>> templateThreadlocalParamMapCache = new ThreadLocal<Map<String, Object>>(){

        @Override
        protected Map<String, Object> initialValue() {
            return new HashMap<String, Object>();
        }
    };
    protected static ThreadLocal<Set<String>> directReplaceKeysCache = new ThreadLocal<Set<String>>(){

        @Override
        protected Set<String> initialValue() {
            return new HashSet<String>();
        }
    };

    public TemplateQueryRunner() {
    }

    public TemplateQueryRunner(DataSource ds) {
        super(ds);
    }

    public TemplateQueryRunner(DataSource ds, ConnectionManager cm) {
        super(ds, cm);
    }

    public SqlTemplateEngine getSqlTemplateEngine() {
        return this.sqlTemplateEngine;
    }

    public void setSqlTemplateEngine(SqlTemplateEngine sqlTemplateEngine) {
        this.sqlTemplateEngine = sqlTemplateEngine;
    }

    protected static void clearBind() {
        templateThreadlocalParamMapCache.get().clear();
        directReplaceKeysCache.get().clear();
    }

    public static String bind0() {
        TemplateQueryRunner.clearBind();
        return "";
    }

    public static String put0(String name, Object value) {
        TemplateQueryRunner.clearBind();
        return TemplateQueryRunner.put(name, value);
    }

    public static String put(String name, Object value) {
        templateThreadlocalParamMapCache.get().put(name, value);
        return "";
    }

    public static String replace0(String name, Object value) {
        TemplateQueryRunner.clearBind();
        return TemplateQueryRunner.replace(name, value);
    }

    public static String replace(String name, Object value) {
        templateThreadlocalParamMapCache.get().put(name, value);
        directReplaceKeysCache.get().add(name);
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SqlAndParams templateToSqlAndParams(String ... sqlTemplate) {
        try {
            String sql = null;
            if (sqlTemplate != null) {
                StringBuilder sb = new StringBuilder("");
                for (String str : sqlTemplate) {
                    sb.append(str);
                }
                sql = sb.toString();
            }
            Map<String, Object> paramMap = templateThreadlocalParamMapCache.get();
            SqlAndParams sqlAndParams = this.sqlTemplateEngine.render(sql, paramMap, directReplaceKeysCache.get());
            return sqlAndParams;
        }
        finally {
            TemplateQueryRunner.clearBind();
        }
    }

    public <T> T templateQuery(Connection conn, ResultSetHandler<T> rsh, String ... templateSQL) throws SQLException {
        SqlAndParams sp = this.templateToSqlAndParams(templateSQL);
        return (T)this.query(conn, sp.getSql(), rsh, sp.getParams());
    }

    public <T> T templateQuery(ResultSetHandler<T> rsh, String ... templateSQL) throws SQLException {
        SqlAndParams sp = this.templateToSqlAndParams(templateSQL);
        return (T)this.query(sp.getSql(), rsh, sp.getParams());
    }

    public int templateUpdate(Connection conn, String ... templateSQL) throws SQLException {
        SqlAndParams sp = this.templateToSqlAndParams(templateSQL);
        return this.update(conn, sp.getSql(), sp.getParams());
    }

    public int templateUpdate(String ... templateSQL) throws SQLException {
        SqlAndParams sp = this.templateToSqlAndParams(templateSQL);
        return this.update(sp.getSql(), sp.getParams());
    }

    public <T> T templateInsert(ResultSetHandler<T> rsh, String ... templateSQL) throws SQLException {
        SqlAndParams sp = this.templateToSqlAndParams(templateSQL);
        return (T)this.insert(sp.getSql(), rsh, sp.getParams());
    }

    public <T> T templateInsert(Connection conn, ResultSetHandler<T> rsh, String ... templateSQL) throws SQLException {
        SqlAndParams sp = this.templateToSqlAndParams(templateSQL);
        return (T)this.insert(conn, sp.getSql(), rsh, sp.getParams());
    }

    public int templateExecute(Connection conn, String ... templateSQL) throws SQLException {
        SqlAndParams sp = this.templateToSqlAndParams(templateSQL);
        return this.execute(conn, sp.getSql(), sp.getParams());
    }

    public int templateExecute(String ... templateSQL) throws SQLException {
        SqlAndParams sp = this.templateToSqlAndParams(templateSQL);
        return this.execute(sp.getSql(), sp.getParams());
    }

    public <T> List<T> templateExecute(Connection conn, ResultSetHandler<T> rsh, String ... templateSQL) throws SQLException {
        SqlAndParams sp = this.templateToSqlAndParams(templateSQL);
        return this.execute(conn, sp.getSql(), rsh, sp.getParams());
    }

    public <T> List<T> templateExecute(ResultSetHandler<T> rsh, String ... templateSQL) throws SQLException {
        SqlAndParams sp = this.templateToSqlAndParams(templateSQL);
        return this.execute(sp.getSql(), rsh, sp.getParams());
    }
}

