/*
 * jDialects, a tiny SQL dialect tool
 *
 * License: GNU Lesser General Public License (LGPL), version 2.1 or later. See
 * the lgpl.txt file in the root directory or
 * <http://www.gnu.org/licenses/lgpl-2.1.html>.
 */
package com.github.drinkjava2.jdialects.id;

import java.util.UUID;

import com.github.drinkjava2.jdbpro.NormalJdbcTool;
import com.github.drinkjava2.jdialects.Dialect;
import com.github.drinkjava2.jdialects.Type;
import com.github.drinkjava2.jdialects.annotation.jpa.GenerationType;

/**
 * Generate a JDK 36 letters random UUID generated by
 * UUID.randomUUID().toString(), for example:</br>
 * d3ad36c0-c6c2-495c-a414-b9cc4a0a7a93
 * 
 * @author Yong Zhu
 * @version 1.0.0
 * @since 1.0.0
 */
public class UUID36Generator implements IdGenerator {
	public static final UUID36Generator INSTANCE = new UUID36Generator();

	@Override
	public GenerationType getGenerationType() {
		return GenerationType.UUID36;
	}

	@Override
	public String getIdGenName() {
		return "UUID36";
	}

	@Override
	public Object getNextID(NormalJdbcTool jdbc, Dialect dialect, Type dataType) {
		return UUID.randomUUID().toString();
	}

	@Override
	public Boolean dependOnAutoIdGenerator() {
		return false;
	}

	@Override
	public IdGenerator newCopy() {
		return INSTANCE;
	}
 
}
