package com.github.drinkjava2.jdialects.id;

import com.github.drinkjava2.jdbpro.NormalJdbcTool;
import com.github.drinkjava2.jdialects.Dialect;
import com.github.drinkjava2.jdialects.DialectException;
import com.github.drinkjava2.jdialects.Type;
import com.github.drinkjava2.jdialects.annotation.jpa.GenerationType;

/**
 * SnowflakeGenerator is a special generator, only mark this column is a
 * snowflake type column, but getNextID() method does not work, because
 * snowflake value should generated by outside program, it depends on real
 * machine setting, in jDialects there is a SnowflakeCreator tool for these
 * outside program to use
 */
@SuppressWarnings("all")
public class SnowflakeGenerator implements IdGenerator {
	public final static SnowflakeGenerator INSTANCE = new SnowflakeGenerator();

	@Override
	public Object getNextID(NormalJdbcTool jdbc, Dialect dialect, Type dataType) {
		throw new DialectException("Snowflake type column value should generated by outside program.");
	}

	@Override
	public GenerationType getGenerationType() {
		return GenerationType.SNOWFLAKE;
	}

	@Override
	public String getIdGenName() {
		return "SNOWFLAKE";
	}

	@Override
	public IdGenerator newCopy() {
		return INSTANCE;
	}

	@Override
	public Boolean dependOnAutoIdGenerator() {
		return false;
	}

}