/*
 * Decompiled with CFR 0.152.
 */
package com.github.eikecochu.sqlbuilder;

import com.github.eikecochu.sqlbuilder.BeforeFrom;
import com.github.eikecochu.sqlbuilder.BeforeGroupBy;
import com.github.eikecochu.sqlbuilder.BeforeJoin;
import com.github.eikecochu.sqlbuilder.BeforeOrderBy;
import com.github.eikecochu.sqlbuilder.BeforeUnion;
import com.github.eikecochu.sqlbuilder.BeforeWhere;
import com.github.eikecochu.sqlbuilder.QueryBuilder;
import com.github.eikecochu.sqlbuilder.QueryOptions;
import com.github.eikecochu.sqlbuilder.QueryPart;
import com.github.eikecochu.sqlbuilder.QueryPartImpl;
import com.github.eikecochu.sqlbuilder.QueryUtils;
import com.github.eikecochu.sqlbuilder.StringJoiner;
import com.github.eikecochu.sqlbuilder.StringUtils;
import com.github.eikecochu.sqlbuilder.Table;
import java.util.ArrayList;
import java.util.List;

public class From
extends QueryPartImpl<From>
implements QueryBuilder<From>,
BeforeJoin<From>,
BeforeWhere<From>,
BeforeGroupBy<From>,
BeforeOrderBy<From>,
BeforeUnion<From> {
    private final List<FromOrigin> origins = new ArrayList<FromOrigin>();

    protected From(BeforeFrom<?> parent) {
        super(parent);
    }

    public From table(String table) {
        String[] parts;
        String alias = null;
        if (table.toUpperCase().contains(" AS ")) {
            table = table.replaceAll("\\s+[Aa][Ss]\\s+", " ");
        }
        if ((parts = table.split("\\s+")).length > 1) {
            table = parts[0];
            alias = parts[1];
        }
        this.origins.add(new FromOrigin().table(table).alias(alias));
        return this;
    }

    public From table(Table table) {
        return this.table(table.tableName());
    }

    public From tables(String ... tables) {
        if (tables != null) {
            for (String table : StringUtils.filterValues(tables)) {
                this.table(table);
            }
        }
        return this;
    }

    public From tables(Table ... tables) {
        for (Table table : tables) {
            this.table(table);
        }
        return this;
    }

    public From subquery(QueryBuilder<?> subquery, String alias) {
        this.origins.add(new FromOrigin().subquery(subquery).alias(alias));
        return this;
    }

    public From subquery(QueryBuilder<?> subquery) {
        return this.subquery(subquery, null);
    }

    @Override
    public String string(QueryOptions options) {
        StringJoiner strings = new StringJoiner();
        if (this.parent() != null) {
            strings.add(this.parent().string(options));
        }
        if (strings.notEmpty()) {
            strings.add(options.newLine());
        }
        if (this.sql() != null) {
            strings.add(options.padded(this.sql()));
        } else {
            strings.add(options.padCased("FROM"));
            strings.add(" ");
            StringJoiner fromStrings = new StringJoiner();
            for (FromOrigin origin : this.origins) {
                fromStrings.add(origin.string(options));
            }
            strings.add(fromStrings.toString(", "));
        }
        return strings.toString();
    }

    public String toString() {
        return "From(origins=" + this.origins + ")";
    }

    public From() {
    }

    private static class FromOrigin
    implements QueryPart {
        private String table;
        private QueryBuilder<?> subquery;
        private String alias;

        private FromOrigin() {
        }

        @Override
        public String string(QueryOptions options) {
            if (this.table != null) {
                return QueryUtils.splitName(options, this.table).string(options) + (this.alias != null ? " " + this.alias : "");
            }
            return "(" + this.subquery.string(options) + ")" + (this.alias != null ? " " + this.alias : "");
        }

        public String toString() {
            return "From.FromOrigin(table=" + this.table() + ", subquery=" + this.subquery() + ", alias=" + this.alias() + ")";
        }

        public String table() {
            return this.table;
        }

        public QueryBuilder<?> subquery() {
            return this.subquery;
        }

        public String alias() {
            return this.alias;
        }

        public FromOrigin table(String table) {
            this.table = table;
            return this;
        }

        public FromOrigin subquery(QueryBuilder<?> subquery) {
            this.subquery = subquery;
            return this;
        }

        public FromOrigin alias(String alias) {
            this.alias = alias;
            return this;
        }
    }
}

