/*
 * Decompiled with CFR 0.152.
 */
package com.github.eikecochu.sqlbuilder;

import com.github.eikecochu.sqlbuilder.BeforeGroupBy;
import com.github.eikecochu.sqlbuilder.BeforeHaving;
import com.github.eikecochu.sqlbuilder.BeforeOrderBy;
import com.github.eikecochu.sqlbuilder.BeforeUnion;
import com.github.eikecochu.sqlbuilder.QueryBuilder;
import com.github.eikecochu.sqlbuilder.QueryOptions;
import com.github.eikecochu.sqlbuilder.QueryPartImpl;
import com.github.eikecochu.sqlbuilder.QueryUtils;
import com.github.eikecochu.sqlbuilder.StringJoiner;
import com.github.eikecochu.sqlbuilder.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class GroupBy
extends QueryPartImpl<GroupBy>
implements QueryBuilder<GroupBy>,
BeforeOrderBy<GroupBy>,
BeforeHaving<GroupBy>,
BeforeUnion<GroupBy> {
    private final List<String> columns = new ArrayList<String>();

    protected GroupBy(BeforeGroupBy<?> parent) {
        super(parent);
    }

    public GroupBy column(String column) {
        this.columns.add(column);
        return this;
    }

    public GroupBy columns(String ... columns) {
        if (columns != null) {
            this.columns.addAll(StringUtils.filterValues(columns));
        }
        return this;
    }

    @Override
    public String string(QueryOptions options) {
        StringJoiner strings = new StringJoiner();
        if (this.parent() != null) {
            strings.add(this.parent().string(options));
        }
        if (strings.notEmpty()) {
            strings.add(options.newLine());
        }
        if (this.sql() != null) {
            strings.add(options.padded(this.sql()));
        } else if (!this.columns.isEmpty()) {
            strings.add(options.padCased("GROUP BY"));
            StringJoiner columnsStrings = new StringJoiner();
            for (String column : this.columns) {
                columnsStrings.add(QueryUtils.splitName(options, column).string(options));
            }
            strings.add(" ");
            strings.add(columnsStrings.toString(", "));
        }
        return strings.toString();
    }

    public String toString() {
        return "GroupBy(columns=" + this.columns + ")";
    }

    public GroupBy() {
    }
}

