/*
 * Decompiled with CFR 0.152.
 */
package com.github.eikecochu.sqlbuilder;

import com.github.eikecochu.sqlbuilder.BeforeUpdate;
import com.github.eikecochu.sqlbuilder.BeforeWhere;
import com.github.eikecochu.sqlbuilder.QueryBuilder;
import com.github.eikecochu.sqlbuilder.QueryOptions;
import com.github.eikecochu.sqlbuilder.QueryPart;
import com.github.eikecochu.sqlbuilder.QueryPartImpl;
import com.github.eikecochu.sqlbuilder.QueryUtils;
import com.github.eikecochu.sqlbuilder.StringJoiner;
import com.github.eikecochu.sqlbuilder.Table;
import com.github.eikecochu.sqlbuilder.UpdateValue;
import com.github.eikecochu.sqlbuilder.ValueHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Update
extends QueryPartImpl<Update>
implements QueryBuilder<Update>,
BeforeWhere<Update> {
    private UpdateType updateType = UpdateType.UPDATE;
    private final String table;
    private final List<UpdateValue> updateValues = new ArrayList<UpdateValue>();

    public Update(String table) {
        this(null, table);
    }

    public Update(Table table) {
        this(table.tableName());
    }

    protected Update(BeforeUpdate<?> parent, String table) {
        super(parent);
        this.table = table;
    }

    private Update setType(UpdateType updateType) {
        this.updateType = updateType;
        return this;
    }

    public Update orRollback() {
        return this.setType(UpdateType.UPDATE_OR_ROLLBACK);
    }

    public Update orAbort() {
        return this.setType(UpdateType.UPDATE_OR_ABORT);
    }

    public Update orFail() {
        return this.setType(UpdateType.UPDATE_OR_FAIL);
    }

    public Update orReplace() {
        return this.setType(UpdateType.UPDATE_OR_REPLACE);
    }

    public Update orIgnore() {
        return this.setType(UpdateType.UPDATE_OR_IGNORE);
    }

    public UpdateValue set(String column) {
        UpdateValue updateValue = new UpdateValue(this, column);
        this.updateValues.add(updateValue);
        return updateValue;
    }

    public Update set(String column, Object value) {
        return this.set(column).value(value);
    }

    public Update set(ValueHolder values) {
        for (Map.Entry<String, Object> entry : values) {
            this.set(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public String string(QueryOptions options) {
        StringJoiner strings = new StringJoiner();
        if (this.parent() != null) {
            strings.add(this.parent().string(options));
        }
        if (strings.notEmpty()) {
            strings.add(options.newLine());
        }
        if (this.sql() != null) {
            strings.add(options.padded(this.sql()));
        } else {
            strings.add(options.padCased(this.updateType.string(options)));
            strings.add(" ");
            strings.add(this.table);
            strings.add(options.newLine());
            strings.add(options.padCased("SET"));
            strings.add(" ");
            StringJoiner sets = new StringJoiner();
            for (UpdateValue updateValue : this.updateValues) {
                String column = QueryUtils.splitName(options, updateValue.column()).string(options) + " = ";
                if (updateValue.expression()) {
                    column = column + updateValue.value().toString();
                } else if (options.prepare()) {
                    column = column + "?";
                    options.addPreparedValue(updateValue.value());
                } else {
                    column = column + QueryUtils.valueToString(options, updateValue.value());
                }
                sets.add(column);
            }
            strings.add(sets.toString(", "));
        }
        return strings.toString();
    }

    public String toString() {
        return "Update(updateType=" + this.updateType + ", table=" + this.table + ", updateValues=" + this.updateValues + ")";
    }

    protected Update updateType(UpdateType updateType) {
        this.updateType = updateType;
        return this;
    }

    private static enum UpdateType implements QueryPart
    {
        UPDATE("UPDATE"),
        UPDATE_OR_ROLLBACK("UPDATE OR ROLLBACK"),
        UPDATE_OR_ABORT("UPDATE OR ABORT"),
        UPDATE_OR_REPLACE("UPDATE OR REPLACE"),
        UPDATE_OR_FAIL("UPDATE OR FAIL"),
        UPDATE_OR_IGNORE("UPDATE OR IGNORE");

        private final String string;

        private UpdateType(String string2) {
            this.string = string2;
        }

        @Override
        public String string(QueryOptions options) {
            return options.cased(this.string);
        }

        public String toString() {
            return "Update.UpdateType." + this.name() + "(string=" + this.string + ")";
        }
    }
}

