/*
 * Decompiled with CFR 0.152.
 */
package com.github.eikecochu.sqlbuilder;

import java.util.Iterator;
import java.util.Map;

public interface ValueHolder
extends Iterable<Map.Entry<String, Object>> {
    public static ValueHolder from(Iterable<? extends Map.Entry<String, Object>> it) {
        return (ValueHolder)it;
    }

    public static ValueHolder from(Map<String, Object> map) {
        return map == null ? null : ValueHolder.from(map.entrySet());
    }

    public static Map.Entry<String, Object> entry(String string, Object object) {
        return new ValueEntry(string, object);
    }

    @Override
    default public Iterator<Map.Entry<String, Object>> iterator() {
        return null;
    }

    default public Iterator<Map.Entry<String, Object>> values(final String columnPrefix) {
        final Iterator<Map.Entry<String, Object>> it = this.iterator();
        if (it == null || columnPrefix == null || columnPrefix.isEmpty()) {
            return it;
        }
        return new Iterator<Map.Entry<String, Object>>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public Map.Entry<String, Object> next() {
                return new EntryWrapper((Map.Entry)it.next(), columnPrefix);
            }
        };
    }

    public static class EntryWrapper
    implements Map.Entry<String, Object> {
        private final Map.Entry<String, Object> entry;
        private final String prefix;

        @Override
        public String getKey() {
            return this.prefix + "." + this.entry.getKey();
        }

        @Override
        public Object getValue() {
            return this.entry.getValue();
        }

        @Override
        public Object setValue(Object value) {
            return this.entry.setValue(value);
        }

        public EntryWrapper(Map.Entry<String, Object> entry, String prefix) {
            this.entry = entry;
            this.prefix = prefix;
        }
    }

    public static class ValueEntry
    implements Map.Entry<String, Object> {
        private String key;
        private Object value;

        @Override
        public Object setValue(Object value) {
            Object prev = value;
            this.value = value;
            return prev;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public ValueEntry(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        public ValueEntry() {
        }
    }
}

