/*
 * Decompiled with CFR 0.152.
 */
package com.eoscode.springapitools.data.filter;

import com.eoscode.springapitools.data.filter.FilterDefinition;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.data.jpa.domain.Specification;

public class DefaultSpecification<T>
implements Specification<T> {
    private Join join;
    private FilterDefinition criteria;

    public DefaultSpecification(FilterDefinition filterCriteria) {
        this.criteria = filterCriteria;
    }

    public DefaultSpecification(Join join, FilterDefinition filterCriteria) {
        this.join = join;
        this.criteria = filterCriteria;
    }

    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> criteriaQuery, CriteriaBuilder criteriaBuilder) {
        Path path = this.join != null ? this.join.get(this.criteria.getField()) : root.get(this.criteria.getField());
        Class javaType = path.getJavaType();
        if (this.criteria.getOperator().equalsIgnoreCase(Operator.EQ.getValue())) {
            if (javaType == Boolean.TYPE || javaType == Boolean.class) {
                return criteriaBuilder.equal((Expression)path, (Object)Boolean.parseBoolean(this.criteria.getValue().toString()));
            }
            return criteriaBuilder.equal((Expression)path, this.criteria.getValue());
        }
        if (this.criteria.getOperator().equalsIgnoreCase(Operator.NE.getValue())) {
            return criteriaBuilder.notEqual((Expression)path, (Object)this.criteria.getValue().toString());
        }
        if (this.criteria.getOperator().equalsIgnoreCase(Operator.GT.getValue())) {
            return criteriaBuilder.greaterThan((Expression)path, (Comparable)((Object)this.criteria.getValue().toString()));
        }
        if (this.criteria.getOperator().equalsIgnoreCase(Operator.GTE.getValue())) {
            return criteriaBuilder.greaterThanOrEqualTo((Expression)path, (Comparable)((Object)this.criteria.getValue().toString()));
        }
        if (this.criteria.getOperator().equalsIgnoreCase(Operator.LT.getValue())) {
            return criteriaBuilder.lessThan((Expression)path, (Comparable)((Object)this.criteria.getValue().toString()));
        }
        if (this.criteria.getOperator().equalsIgnoreCase(Operator.LTE.getValue())) {
            return criteriaBuilder.lessThanOrEqualTo((Expression)path, (Comparable)((Object)this.criteria.getValue().toString()));
        }
        if (this.criteria.getOperator().equalsIgnoreCase(Operator.LIKE.getValue())) {
            if (root.get(this.criteria.getField()).getJavaType() == String.class) {
                return criteriaBuilder.like((Expression)path, "%" + this.criteria.getValue() + "%");
            }
            return criteriaBuilder.equal((Expression)path, this.criteria.getValue());
        }
        if (this.criteria.getOperator().equalsIgnoreCase(Operator.NOT_LIKE.getValue())) {
            if (root.get(this.criteria.getField()).getJavaType() == String.class) {
                return criteriaBuilder.notLike((Expression)path, "%" + this.criteria.getValue() + "%");
            }
            return criteriaBuilder.notEqual((Expression)path, this.criteria.getValue());
        }
        if (this.criteria.getOperator().equalsIgnoreCase(Operator.IS_NULL.getValue())) {
            return criteriaBuilder.isNull((Expression)path);
        }
        if (this.criteria.getOperator().equalsIgnoreCase(Operator.NOT_NULL.getValue())) {
            return criteriaBuilder.isNotNull((Expression)path);
        }
        return null;
    }

    static enum Operator {
        EQ("="),
        NE("!="),
        GT(">"),
        LT("<"),
        GTE(">="),
        LTE("<="),
        LIKE("$like"),
        NOT_LIKE("$notLike"),
        IS_NULL("$isNull"),
        NOT_NULL("$isNotNull"),
        IN("$in"),
        BTW("$btw"),
        OR("$or"),
        AND("$and");

        private String value;

        private Operator(String value) {
            this.value = value;
        }

        String getValue() {
            return this.value;
        }
    }
}

