/*
 * Decompiled with CFR 0.152.
 */
package com.eoscode.springapitools.data.filter;

import com.eoscode.springapitools.data.filter.DefaultSpecification;
import com.eoscode.springapitools.data.filter.FilterDefinition;
import com.eoscode.springapitools.data.filter.QueryDefinition;
import com.eoscode.springapitools.data.filter.SortDefinition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import org.springframework.data.jpa.domain.Specification;

public class SpecificationBuilder<T> {
    private Boolean distinct;
    private final List<FilterDefinition> filters = new ArrayList<FilterDefinition>();
    private final Map<String, List<FilterDefinition>> joins = new HashMap<String, List<FilterDefinition>>();
    private final List<SortDefinition> sorts = new ArrayList<SortDefinition>();
    private Specification<T> result = null;

    public SpecificationBuilder() {
    }

    public SpecificationBuilder(boolean distinct) {
        this();
        this.distinct = distinct;
    }

    public SpecificationBuilder distinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    public SpecificationBuilder filter(String field, String operation, Object value) {
        this.filter(new FilterDefinition(field, operation, value));
        return this;
    }

    public SpecificationBuilder filter(FilterDefinition filter) {
        String[] fields = filter.getField().split("\\.");
        if (fields.length == 2) {
            filter.setField(fields[1]);
            List filters = this.joins.computeIfAbsent(fields[0], k -> new ArrayList());
            filters.add(filter);
            this.joins.put(fields[0], filters);
        } else {
            this.filters.add(filter);
        }
        return this;
    }

    public SpecificationBuilder filters(List<FilterDefinition> filters) {
        filters.forEach(this::filter);
        return this;
    }

    public SpecificationBuilder sort(SortDefinition sort) {
        this.sorts.add(sort);
        return this;
    }

    public SpecificationBuilder sorts(List<SortDefinition> sorts) {
        if (sorts != null) {
            this.sorts.addAll(sorts);
        }
        return this;
    }

    public SpecificationBuilder sort(String field, SortDefinition.Direction direction) {
        this.sorts.add(new SortDefinition(field, direction));
        return this;
    }

    public Specification<T> build(QueryDefinition queryDefinition) {
        this.distinct(queryDefinition.isDistinct()).filters(queryDefinition.getFilters()).sorts(queryDefinition.getSorts());
        return this.build();
    }

    public Specification<T> build() {
        if (this.filters.size() == 0 && this.joins.size() == 0) {
            return null;
        }
        if (this.filters.size() > 0) {
            this.result = this.where(this.filters);
        }
        this.joins.forEach((key, filters) -> {
            this.result = this.result == null ? Specification.where(this.join((String)key, (List<FilterDefinition>)filters)) : Specification.where(this.result).and(this.join((String)key, (List<FilterDefinition>)filters));
        });
        return this.result;
    }

    Specification<T> where(List<FilterDefinition> filters) {
        return (Specification & Serializable)(root, query, builder) -> {
            if (this.distinct != null) {
                query.distinct(this.distinct.booleanValue());
            }
            List specs = filters.stream().map(DefaultSpecification::new).collect(Collectors.toList());
            return builder.and((Predicate[])specs.stream().map(item -> item.toPredicate(root, query, builder)).toArray(Predicate[]::new));
        };
    }

    Specification<T> join(String field, List<FilterDefinition> filters) {
        return (Specification & Serializable)(root, query, builder) -> {
            if (this.distinct != null) {
                query.distinct(this.distinct.booleanValue());
            }
            Join join = root.join(field, JoinType.LEFT);
            List specs = filters.stream().map(filter -> new DefaultSpecification(join, (FilterDefinition)filter)).collect(Collectors.toList());
            return builder.and((Predicate[])specs.stream().map(item -> item.toPredicate(root, query, builder)).toArray(Predicate[]::new));
        };
    }
}

