/*
 * Decompiled with CFR 0.152.
 */
package com.eoscode.springapitools.data.repository;

import com.eoscode.springapitools.service.exceptions.EntityNotFoundException;
import java.util.HashMap;
import java.util.Optional;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.springframework.data.repository.NoRepositoryBean;

@NoRepositoryBean
public class BaseRepository<Entity, ID> {
    @PersistenceContext
    private EntityManager entityManger;

    EntityManager getEntityManger() {
        return this.entityManger;
    }

    Optional<Entity> findWithEntityGraph(String entityGraph, Class<Entity> entityClass, ID id) {
        EntityGraph graph = this.entityManger.createEntityGraph(entityClass.getSimpleName() + "." + entityGraph);
        if (graph == null) {
            return Optional.empty();
        }
        HashMap<String, EntityGraph> hints = new HashMap<String, EntityGraph>();
        hints.put("javax.persistence.fetchgraph", graph);
        Object entity = this.entityManger.find(entityClass, id, hints);
        if (entity == null) {
            throw new EntityNotFoundException("Object not found! Id: " + id + ", Type: " + entityClass.getName());
        }
        return Optional.of(entity);
    }
}

