/*
 * Decompiled with CFR 0.152.
 */
package com.eoscode.springapitools.resource;

import com.eoscode.springapitools.data.domain.Identifier;
import com.eoscode.springapitools.data.filter.QueryDefinition;
import com.eoscode.springapitools.service.AbstractService;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.validation.Valid;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.data.web.SortDefault;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

public abstract class AbstractResource<Service extends AbstractService<?, Entity, ID>, Entity, ID> {
    protected final Log log = LogFactory.getLog(this.getClass());
    @Autowired
    private ApplicationContext applicationContext;
    private Service service;
    private Type serviceType;
    private Type entityType;
    private Type identifierType;
    private Class<Entity> entityClass;

    public AbstractResource() {
        Type type = this.getClass().getGenericSuperclass();
        ParameterizedType pType = (ParameterizedType)type;
        this.serviceType = pType.getActualTypeArguments()[0];
        this.entityType = pType.getActualTypeArguments()[1];
        this.identifierType = pType.getActualTypeArguments()[2];
        this.entityClass = (Class)this.entityType;
    }

    @PostConstruct
    private void metaData() {
        Class serviceClass;
        if (this.applicationContext != null && this.getService() == null && (serviceClass = (Class)this.serviceType).isAnnotationPresent(Service.class)) {
            this.service = (AbstractService)this.applicationContext.getBean(serviceClass);
        }
    }

    public Type getServiceType() {
        return this.serviceType;
    }

    public Type getEntityType() {
        return this.entityType;
    }

    public Type getIdentifierType() {
        return this.identifierType;
    }

    private Class<Entity> getEntityClass() {
        return this.entityClass;
    }

    protected Service getService() {
        return this.service;
    }

    @PostMapping
    public ResponseEntity<Entity> save(@Valid @RequestBody Entity entity) {
        entity = ((AbstractService)this.getService()).save(entity);
        Identifier identifier = null;
        if (entity instanceof Identifier) {
            identifier = (Identifier)entity;
        }
        if (identifier != null) {
            URI uri = ServletUriComponentsBuilder.fromCurrentRequest().path("/{id}").buildAndExpand(new Object[]{identifier.getId()}).toUri();
            return ResponseEntity.created((URI)uri).build();
        }
        return ResponseEntity.ok().body(entity);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Entity> find(@PathVariable ID id) {
        Object entity = ((AbstractService)this.getService()).findById(id);
        return ResponseEntity.ok().body(entity);
    }

    @GetMapping(value={"/detail/{id}"})
    public ResponseEntity<Entity> findDetail(@PathVariable ID id) {
        Object entity = ((AbstractService)this.getService()).findDetailById(id);
        return ResponseEntity.ok().body(entity);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Void> update(@Valid @RequestBody Entity entity, @PathVariable ID id) {
        if (entity instanceof Identifier) {
            Identifier identifier = (Identifier)entity;
            identifier.setId(id);
        }
        ((AbstractService)this.getService()).save(entity);
        return ResponseEntity.noContent().build();
    }

    @PatchMapping(value={"/{id}"})
    public ResponseEntity<Void> patch(@Valid @RequestBody Entity entity, @PathVariable ID id) {
        if (entity instanceof Identifier) {
            Identifier identifier = (Identifier)entity;
            identifier.setId(id);
        }
        ((AbstractService)this.getService()).update(entity);
        return ResponseEntity.noContent().build();
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> delete(@PathVariable ID id) {
        ((AbstractService)this.getService()).deleteById(id);
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"", "/find"})
    public ResponseEntity<Page<Entity>> find(Entity filterBy, @PageableDefault Pageable pageable) {
        Page<Entity> page = ((AbstractService)this.getService()).find(filterBy, pageable);
        return ResponseEntity.ok(page);
    }

    @GetMapping(value={"/query"})
    public ResponseEntity<Page<Entity>> query(@RequestParam(value="opt") String query, @RequestParam(value="distinct", required=false) boolean distinct, @PageableDefault Pageable pageable) {
        Page page = ((AbstractService)this.getService()).query(query, pageable, distinct);
        return ResponseEntity.ok(page);
    }

    @PostMapping(value={"/query"})
    public ResponseEntity<Page<Entity>> query(@RequestBody QueryDefinition queryDefinition, @PageableDefault Pageable pageable) {
        Page page = ((AbstractService)this.getService()).query(queryDefinition, pageable);
        return ResponseEntity.ok(page);
    }

    @GetMapping(value={"/all"})
    public ResponseEntity<List<Entity>> findAll(@SortDefault Sort sort) {
        List list = ((AbstractService)this.getService()).findAll(sort);
        return ResponseEntity.ok(list);
    }

    @GetMapping(value={"/pages"})
    public ResponseEntity<Page<Entity>> findAllPageAndSort(@PageableDefault Pageable pageable) {
        Page page = ((AbstractService)this.getService()).findAllPages(pageable);
        return ResponseEntity.ok(page);
    }
}

