/*
 * Decompiled with CFR 0.152.
 */
package com.eoscode.springapitools.resource.exception;

import com.eoscode.springapitools.resource.exception.StandardError;
import com.eoscode.springapitools.resource.exception.ValidationError;
import com.eoscode.springapitools.service.exceptions.AuthorizationException;
import com.eoscode.springapitools.service.exceptions.EntityNotFoundException;
import com.eoscode.springapitools.service.exceptions.ValidationException;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;

public class BaseResourceExceptionHandler {
    @ExceptionHandler(value={EntityNotFoundException.class})
    public ResponseEntity<StandardError> objectNotFound(EntityNotFoundException e, HttpServletRequest request) {
        StandardError err = new StandardError(System.currentTimeMillis(), HttpStatus.NOT_FOUND.value(), "N\u00e3o encontrado", e.getMessage(), request.getRequestURI());
        return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)err);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity<StandardError> validation(MethodArgumentNotValidException e, HttpServletRequest request) {
        ValidationError err = new ValidationError(System.currentTimeMillis(), HttpStatus.UNPROCESSABLE_ENTITY.value(), "Erro de valida\u00e7\u00e3o", e.getMessage(), request.getRequestURI());
        for (FieldError x : e.getBindingResult().getFieldErrors()) {
            err.addError(x.getField(), x.getDefaultMessage());
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.UNPROCESSABLE_ENTITY).body((Object)err);
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public ResponseEntity<StandardError> constrantViolation(ConstraintViolationException e) {
        ValidationError err = new ValidationError(System.currentTimeMillis(), HttpStatus.UNPROCESSABLE_ENTITY.value(), "Erro de valida\u00e7\u00e3o", e.getMessage(), "");
        for (ConstraintViolation x : e.getConstraintViolations()) {
            err.addError("", x.getMessage());
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.UNPROCESSABLE_ENTITY).body((Object)err);
    }

    @ExceptionHandler(value={ValidationException.class})
    public ResponseEntity<StandardError> validation(ValidationException e, HttpServletRequest request) {
        ValidationError err = new ValidationError(System.currentTimeMillis(), HttpStatus.UNPROCESSABLE_ENTITY.value(), "Erro de valida\u00e7\u00e3o", e.getMessage(), request.getRequestURI());
        err.addError("", e.getMessage());
        return ResponseEntity.status((HttpStatus)HttpStatus.UNPROCESSABLE_ENTITY).body((Object)err);
    }

    @ExceptionHandler(value={AuthorizationException.class})
    public ResponseEntity<StandardError> authorization(AuthorizationException e, HttpServletRequest request) {
        StandardError err = new StandardError(System.currentTimeMillis(), HttpStatus.UNAUTHORIZED.value(), "Acesso negado", e != null ? e.getMessage() : null, request.getRequestURI());
        return ResponseEntity.status((HttpStatus)HttpStatus.UNAUTHORIZED).body((Object)err);
    }

    @ExceptionHandler(value={UsernameNotFoundException.class, AuthenticationException.class})
    public ResponseEntity<StandardError> objectNotFound(AuthenticationException e, HttpServletRequest request) {
        StandardError err = new StandardError(System.currentTimeMillis(), HttpStatus.FORBIDDEN.value(), "Acesso negado", e.getMessage(), request.getRequestURI());
        return ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).body((Object)err);
    }
}

