/*
 * Decompiled with CFR 0.152.
 */
package com.eoscode.springapitools.security.jwt;

import com.eoscode.springapitools.security.Auth;
import com.eoscode.springapitools.security.Credential;
import com.eoscode.springapitools.security.jwt.JWTManager;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

public class JWTAuthenticationFilter
extends UsernamePasswordAuthenticationFilter {
    private AuthenticationManager authenticationManager;
    private JWTManager jwtManager;

    public JWTAuthenticationFilter(AuthenticationManager authenticationManager, JWTManager jwtManager) {
        this.setAuthenticationFailureHandler(new JWTAuthenticationFailureHandler());
        this.authenticationManager = authenticationManager;
        this.jwtManager = jwtManager;
    }

    public Authentication attemptAuthentication(HttpServletRequest req, HttpServletResponse res) throws AuthenticationException {
        try {
            Credential credential = (Credential)new ObjectMapper().readValue((InputStream)req.getInputStream(), Credential.class);
            UsernamePasswordAuthenticationToken authToken = new UsernamePasswordAuthenticationToken((Object)credential.getIdentifier(), (Object)credential.getPassword(), new ArrayList());
            return this.authenticationManager.authenticate((Authentication)authToken);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void successfulAuthentication(HttpServletRequest req, HttpServletResponse res, FilterChain chain, Authentication auth) throws IOException, ServletException {
        String username = ((Auth)auth.getPrincipal()).getUsername();
        String token = this.jwtManager.generateToken(username);
        res.addHeader("Authorization", "Bearer " + token);
        res.addHeader("access-control-expose-headers", "Authorization");
        String json = "{\"id\": \"" + ((Auth)auth.getPrincipal()).getId() + "\", \"token\": \"" + token + "\"}";
        res.getWriter().append(json);
    }

    private static class JWTAuthenticationFailureHandler
    implements AuthenticationFailureHandler {
        private JWTAuthenticationFailureHandler() {
        }

        public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
            response.setStatus(401);
            response.setContentType("application/json");
            response.getWriter().append(this.json());
        }

        private String json() {
            long date = new Date().getTime();
            return "{\"timestamp\": " + date + ", \"status\": 401, \"error\": \"N\u00e3o autorizado\", \"message\": \"Email ou senha inv\u00e1lidos\", \"path\": \"/login\"}";
        }
    }
}

