/*
 * Decompiled with CFR 0.152.
 */
package com.eoscode.springapitools.security.jwt;

import com.eoscode.springapitools.security.jwt.JWTManager;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;

public class JWTAuthorizationFilter
extends BasicAuthenticationFilter {
    private JWTManager jwtManager;
    private UserDetailsService userDetailsService;

    public JWTAuthorizationFilter(AuthenticationManager authenticationManager, JWTManager jwtManager, UserDetailsService userDetailsService) {
        super(authenticationManager);
        this.jwtManager = jwtManager;
        this.userDetailsService = userDetailsService;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        UsernamePasswordAuthenticationToken auth;
        String header = request.getHeader("Authorization");
        if (header != null && header.startsWith("Bearer ") && (auth = this.getAuthentication(header.substring(7))) != null) {
            SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private UsernamePasswordAuthenticationToken getAuthentication(String token) {
        if (this.jwtManager.isValid(token)) {
            String username = this.jwtManager.getUsername(token);
            UserDetails user = this.userDetailsService.loadUserByUsername(username);
            return new UsernamePasswordAuthenticationToken((Object)user, null, user.getAuthorities());
        }
        return null;
    }
}

