/*
 * Decompiled with CFR 0.152.
 */
package com.eoscode.springapitools.security.jwt;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Value;

public class JWTManager {
    @Value(value="${security.jwt.secret}")
    private String secret;
    @Value(value="${security.jwt.expiration}")
    private Long expiration;

    public String generateToken(String username) {
        return Jwts.builder().setSubject(username).setExpiration(new Date(System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(this.expiration))).signWith(SignatureAlgorithm.HS512, this.secret.getBytes()).compact();
    }

    public boolean isValid(String token) {
        Claims claims = this.getClaims(token);
        if (claims != null) {
            String username = claims.getSubject();
            Date expirationDate = claims.getExpiration();
            Date now = new Date(System.currentTimeMillis());
            return username != null && expirationDate != null && now.before(expirationDate);
        }
        return false;
    }

    public String getUsername(String token) {
        Claims claims = this.getClaims(token);
        if (claims != null) {
            return claims.getSubject();
        }
        return null;
    }

    private Claims getClaims(String token) {
        try {
            return (Claims)Jwts.parser().setSigningKey(this.secret.getBytes()).parseClaimsJws(token).getBody();
        }
        catch (Exception e) {
            return null;
        }
    }
}

