/*
 * Decompiled with CFR 0.152.
 */
package com.eoscode.springapitools.service;

import com.eoscode.springapitools.data.domain.Find;
import com.eoscode.springapitools.data.domain.FindAttribute;
import com.eoscode.springapitools.data.domain.Identifier;
import com.eoscode.springapitools.data.domain.NoDelete;
import com.eoscode.springapitools.data.filter.FilterDefinition;
import com.eoscode.springapitools.data.filter.QueryDefinition;
import com.eoscode.springapitools.data.filter.SortDefinition;
import com.eoscode.springapitools.data.filter.SpecificationBuilder;
import com.eoscode.springapitools.data.repository.CustomDeleteByIdRepository;
import com.eoscode.springapitools.data.repository.CustomFindByIdRepository;
import com.eoscode.springapitools.data.repository.Repository;
import com.eoscode.springapitools.service.exceptions.EntityNotFoundException;
import com.eoscode.springapitools.util.NullAwareBeanUtilsBean;
import com.eoscode.springapitools.util.ReflectionUtils;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.persistence.criteria.Expression;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractService<Repository extends Repository<Entity, ID>, Entity, ID> {
    private final Log log = LogFactory.getLog(this.getClass());
    @Autowired
    private CustomFindByIdRepository customFindByIdRepository;
    @Autowired
    private CustomDeleteByIdRepository customDeleteByIdRepository;
    @Autowired
    private ApplicationContext applicationContext;
    private Repository repository;
    private Type repositoryType;
    private Type entityType;
    private Type identifierType;
    private Class<Entity> entityClass;
    private Set<Field> ignoreWithFindAttributeAnnotation;

    public AbstractService() {
        Type type = this.getClass().getGenericSuperclass();
        ParameterizedType pType = (ParameterizedType)type;
        this.repositoryType = pType.getActualTypeArguments()[0];
        this.entityType = pType.getActualTypeArguments()[1];
        this.identifierType = pType.getActualTypeArguments()[2];
        this.entityClass = (Class)this.entityType;
    }

    public AbstractService(ApplicationContext applicationContext, Type repositoryType, Type entityType, Type identifierType) {
        this.applicationContext = applicationContext;
        this.repositoryType = repositoryType;
        this.entityType = entityType;
        this.identifierType = identifierType;
        this.entityClass = (Class)entityType;
        this.metaData();
    }

    public Type getRepositoryType() {
        return this.repositoryType;
    }

    private Type getEntityType() {
        return this.entityType;
    }

    public Type getIdentifierType() {
        return this.identifierType;
    }

    private Class<Entity> getEntityClass() {
        return this.entityClass;
    }

    protected Repository getRepository() {
        return this.repository;
    }

    @PostConstruct
    private void metaData() {
        this.ignoreWithFindAttributeAnnotation = org.reflections.ReflectionUtils.getAllFields(this.entityClass, (Predicate[])new Predicate[]{org.reflections.ReflectionUtils.withAnnotation((Annotation)new FindAttribute(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return FindAttribute.class;
            }

            @Override
            public boolean ignore() {
                return true;
            }
        })});
        if (this.applicationContext != null) {
            if (this.getRepository() == null) {
                this.repository = (Repository)this.applicationContext.getBean((Class)this.getRepositoryType());
            }
            if (this.customFindByIdRepository == null) {
                this.customFindByIdRepository = (CustomFindByIdRepository)this.applicationContext.getBean(CustomFindByIdRepository.class);
            }
            if (this.customDeleteByIdRepository == null) {
                this.customDeleteByIdRepository = (CustomDeleteByIdRepository)this.applicationContext.getBean(CustomDeleteByIdRepository.class);
            }
        }
    }

    @Transactional
    public Entity save(Entity entity) {
        Object id = null;
        if (entity instanceof Identifier) {
            id = ((Identifier)entity).getId();
        }
        Class classType = (Class)this.entityType;
        if (id == null && classType.isAnnotationPresent(NoDelete.class)) {
            NoDelete noDelete = classType.getAnnotation(NoDelete.class);
            try {
                Field field = classType.getDeclaredField(noDelete.field());
                field.setAccessible(true);
                field.set(entity, ReflectionUtils.getObject(field, noDelete.defaultValue()));
            }
            catch (Exception e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return (Entity)this.getRepository().save(entity);
    }

    @Transactional
    public Entity update(Entity entity) throws EntityNotFoundException {
        Object entityOld = null;
        if (entity instanceof Identifier) {
            Object id = ((Identifier)entity).getId();
            entityOld = this.findById(id);
        }
        if (entityOld != null) {
            try {
                NullAwareBeanUtilsBean.getInstance().copyProperties(entityOld, entity);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
            return (Entity)this.getRepository().save(entityOld);
        }
        return (Entity)this.getRepository().save(entity);
    }

    public Entity findById(ID id) throws EntityNotFoundException {
        EntityNotFoundException objectNotFound = new EntityNotFoundException("Object not found! Id: " + id + ", Type: " + this.getEntityType().getTypeName());
        Optional<Entity> result = this.customFindByIdRepository.findCustomById(this.getEntityClass(), id);
        return result.orElse(this.getRepository().findById(id).orElseThrow(() -> objectNotFound));
    }

    public Entity findDetailById(ID id) throws EntityNotFoundException {
        Class classType = (Class)this.entityType;
        Optional result = this.customFindByIdRepository.findDetailById(classType, id);
        return (Entity)result.orElseGet(() -> this.findById(id));
    }

    public boolean existsById(ID id) {
        return this.getRepository().existsById(id);
    }

    @Transactional
    public void deleteById(ID id) {
        Entity entity = this.findById(id);
        Class classEntity = (Class)this.entityType;
        if (classEntity.isAnnotationPresent(NoDelete.class)) {
            this.customDeleteByIdRepository.deleteById(classEntity, id);
        } else {
            this.getRepository().deleteById(id);
        }
    }

    @Transactional
    public void delete(Entity entity) {
        Class classEntity = (Class)this.entityType;
        if (classEntity.isAnnotationPresent(NoDelete.class)) {
            Object id = ((Identifier)entity).getId();
            this.customDeleteByIdRepository.deleteById(classEntity, id);
        } else {
            this.getRepository().delete(entity);
        }
    }

    public List<Entity> find(Entity filterBy) {
        Example<Entity> example = this.getDefaultExample(filterBy);
        return this.getRepository().findAll(example);
    }

    public List<Entity> find(Entity filterBy, Sort sort) {
        Example<Entity> example = this.getDefaultExample(filterBy);
        if (sort != null) {
            return this.getRepository().findAll(example, sort);
        }
        return this.getRepository().findAll(example);
    }

    public Page<Entity> find(Entity filterBy, Pageable pageable) {
        Example<Entity> example = this.getDefaultExample(filterBy);
        return this.getRepository().findAll(example, pageable);
    }

    public Page<Entity> query(String query, Pageable pageable, Boolean distinct) {
        ArrayList<FilterDefinition> criteria = new ArrayList<FilterDefinition>();
        Pattern pattern = Pattern.compile("(\\w+.?\\w*)(>=|<=|>|<|=|!=|\\$like|\\$notLike|\\$isNull|\\$isNotNull)([\\w]{8}(-[\\w]{4}){3}-[\\w]{12}|\\w+-?\\w*),", 256);
        Matcher matcher = pattern.matcher(query + ",");
        while (matcher.find()) {
            criteria.add(new FilterDefinition(matcher.group(1), matcher.group(2), matcher.group(3)));
        }
        QueryDefinition queryDefinition = new QueryDefinition();
        queryDefinition.setDistinct(distinct);
        queryDefinition.setFilters(criteria);
        return this.query(queryDefinition, pageable);
    }

    public List<Entity> query(QueryDefinition queryDefinition) {
        return this.getRepository().findAll(this.getDefaultSpecification(queryDefinition));
    }

    public Page<Entity> query(QueryDefinition queryDefinition, Pageable pageable) {
        pageable = this.getDefaultSortAndPageRequest(queryDefinition.getSorts(), pageable);
        return this.getRepository().findAll(this.getDefaultSpecification(queryDefinition), pageable);
    }

    public List<Entity> findAll() {
        return this.findAll(Sort.unsorted());
    }

    public List<Entity> findAll(Sort sort) {
        Specification specification = null;
        if (this.getEntityClass().isAnnotationPresent(NoDelete.class)) {
            NoDelete noDelete = this.getEntityClass().getAnnotation(NoDelete.class);
            try {
                Field field = this.getEntityClass().getDeclaredField(noDelete.field());
                specification = Specification.where(this.hasField(noDelete.field(), ReflectionUtils.getObject(field, noDelete.defaultValue())));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("error in identify noDeleteEntity field for findAll", e);
            }
        }
        return this.getRepository().findAll(specification, sort);
    }

    public Page<Entity> findAllPages(Pageable pageable) {
        if (this.getEntityClass().isAnnotationPresent(NoDelete.class)) {
            Specification specification;
            NoDelete noDelete = this.getEntityClass().getAnnotation(NoDelete.class);
            try {
                Field field = this.getEntityClass().getDeclaredField(noDelete.field());
                specification = Specification.where(this.hasField(noDelete.field(), ReflectionUtils.getObject(field, noDelete.defaultValue())));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("error in identify noDeleteEntity field for findAllPages", e);
            }
            return this.getRepository().findAll(specification, pageable);
        }
        return this.getRepository().findAll(pageable);
    }

    Specification<Entity> hasField(String field, Object value) {
        return (Specification & Serializable)(root, cq, cb) -> cb.equal((Expression)root.get(field), value);
    }

    Specification<Entity> getDefaultSpecification(QueryDefinition queryDefinition) {
        List<FilterDefinition> criteria = queryDefinition.getFilters();
        SpecificationBuilder builder = new SpecificationBuilder();
        builder.distinct(queryDefinition.isDistinct());
        builder.sorts(queryDefinition.getSorts());
        criteria.forEach(builder::filter);
        Specification spec = builder.build();
        boolean ignoreNoDeleteAnnotation = false;
        if (this.getEntityClass().isAnnotationPresent(Find.class)) {
            Find find = this.getEntityClass().getAnnotation(Find.class);
            ignoreNoDeleteAnnotation = find.ignoreNoDeleteAnnotation();
        }
        if (!ignoreNoDeleteAnnotation && this.getEntityClass().isAnnotationPresent(NoDelete.class)) {
            NoDelete noDelete = this.getEntityClass().getAnnotation(NoDelete.class);
            try {
                Field field = this.getEntityClass().getDeclaredField(noDelete.field());
                spec = Specification.where(spec).and(this.hasField(noDelete.field(), ReflectionUtils.getObject(field, noDelete.defaultValue())));
            }
            catch (Exception e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return spec;
    }

    Example<Entity> getDefaultExample(Entity entity) {
        ExampleMatcher matcher = ExampleMatcher.matching().withIgnoreNullValues().withStringMatcher(ExampleMatcher.StringMatcher.EXACT).withIgnoreCase();
        boolean ignoreNoDeleteAnnotation = false;
        if (this.getEntityClass().isAnnotationPresent(Find.class)) {
            Find find = this.getEntityClass().getAnnotation(Find.class);
            ignoreNoDeleteAnnotation = find.ignoreNoDeleteAnnotation();
            HashSet<String> ignores = new HashSet<String>();
            if (matcher.getIgnoredPaths() != null && !matcher.getIgnoredPaths().isEmpty()) {
                ignores.addAll(matcher.getIgnoredPaths());
            }
            if (find.ignoreAttributes().length > 0) {
                ignores.addAll(Arrays.asList(find.ignoreAttributes()));
            }
            if (!this.ignoreWithFindAttributeAnnotation.isEmpty()) {
                ignores.addAll(this.ignoreWithFindAttributeAnnotation.stream().map(Field::getName).collect(Collectors.toList()));
            }
            if (!ignores.isEmpty()) {
                matcher = matcher.withIgnorePaths(ignores.toArray(new String[0]));
            }
        }
        if (!ignoreNoDeleteAnnotation && this.getEntityClass().isAnnotationPresent(NoDelete.class)) {
            NoDelete noDelete = this.getEntityClass().getAnnotation(NoDelete.class);
            try {
                Field field = this.getEntityClass().getDeclaredField(noDelete.field());
                field.setAccessible(true);
                field.set(entity, ReflectionUtils.getObject(field, noDelete.defaultValue()));
                matcher = matcher.withMatcher(noDelete.field(), ExampleMatcher.GenericPropertyMatchers.exact());
            }
            catch (Exception e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return Example.of(entity, (ExampleMatcher)matcher);
    }

    ExampleMatcher getDefaultNoDeleteMatcher() {
        if (this.getEntityClass().isAnnotationPresent(NoDelete.class)) {
            NoDelete noDelete = this.getEntityClass().getAnnotation(NoDelete.class);
            try {
                Entity entity = this.getEntityClass().newInstance();
                Field field = this.getEntityClass().getDeclaredField(noDelete.field());
                field.setAccessible(true);
                field.set(entity, 1);
                String[] fields = (String[])Arrays.stream(this.getEntityClass().getDeclaredFields()).filter(item -> !item.getName().equals(noDelete.field())).map(Field::getName).toArray(String[]::new);
                return ExampleMatcher.matching().withMatcher(noDelete.field(), ExampleMatcher.GenericPropertyMatchers.exact()).withIgnorePaths(fields);
            }
            catch (Exception e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    private List<Sort.Order> getDefaultSort(List<SortDefinition> sorts) {
        ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
        if (sorts != null && sorts.size() > 0) {
            sorts.forEach(sortDefinition -> orders.add(Sort.Order.asc((String)sortDefinition.getField())));
        }
        return orders;
    }

    private Pageable getDefaultSortAndPageRequest(List<SortDefinition> sorts, Pageable pageable) {
        if (pageable == null) {
            return null;
        }
        List<Sort.Order> orders = this.getDefaultSort(sorts);
        return PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)Sort.by(orders));
    }
}

