/*
 * Decompiled with CFR 0.152.
 */
package com.github.esrrhs.fakescript;

import com.github.esrrhs.fakescript.container_addr;
import com.github.esrrhs.fakescript.fake;
import com.github.esrrhs.fakescript.func_binary;
import com.github.esrrhs.fakescript.stack_variant_info;
import com.github.esrrhs.fakescript.types;
import com.github.esrrhs.fakescript.variant;
import java.util.ArrayList;

class codegen {
    private fake m_f;
    private ArrayList<ArrayList<block_identifiers>> m_block_identifiers_stack = new ArrayList();
    private ArrayList<stack_variant_info> m_debug_block_identifiers_list = new ArrayList();
    private int m_stackpos;
    private int m_maxstackpos;
    private ArrayList<Long> m_byte_code_list = new ArrayList();
    private ArrayList<Integer> m_byte_lineno_list = new ArrayList();
    private ArrayList<variant> m_const_list = new ArrayList();
    private ArrayList<container_addr> m_containeraddr_list = new ArrayList();

    public codegen(fake f) {
        this.m_f = f;
    }

    public void push_stack_identifiers() {
        this.m_block_identifiers_stack.add(new ArrayList());
    }

    public void pop_stack_identifiers() {
        ArrayList<block_identifiers> list = this.m_block_identifiers_stack.get(this.m_block_identifiers_stack.size() - 1);
        int stacksize = list.size();
        this.m_block_identifiers_stack.remove(this.m_block_identifiers_stack.size() - 1);
        this.m_stackpos -= stacksize;
    }

    public int add_stack_identifier(String name, int line) {
        if (this.get_cur_variable_pos(name) != -1) {
            return -1;
        }
        ArrayList<block_identifiers> list = this.m_block_identifiers_stack.get(this.m_block_identifiers_stack.size() - 1);
        list.add(new block_identifiers(name, this.m_stackpos));
        int ret = this.m_stackpos++;
        if (this.m_stackpos > this.m_maxstackpos) {
            this.m_maxstackpos = this.m_stackpos;
        }
        stack_variant_info tmp = new stack_variant_info();
        tmp.m_name = name;
        tmp.m_line = line;
        tmp.m_pos = ret;
        this.m_debug_block_identifiers_list.add(tmp);
        return ret;
    }

    public int get_cur_variable_pos(String name) {
        ArrayList<block_identifiers> list = this.m_block_identifiers_stack.get(this.m_block_identifiers_stack.size() - 1);
        for (int i = 0; i < list.size(); ++i) {
            if (!name.equals(list.get((int)i).m_name)) continue;
            return list.get((int)i).m_pos;
        }
        return -1;
    }

    public int byte_code_size() {
        return this.m_byte_code_list.size();
    }

    public void push(long code, int lineno) {
        this.m_byte_code_list.add(code);
        this.m_byte_lineno_list.add(lineno);
    }

    public void set(int pos, long code) {
        this.m_byte_code_list.set(pos, code);
    }

    public int getconst(variant v) {
        for (int i = 0; i < this.m_const_list.size(); ++i) {
            variant vv = this.m_const_list.get(i);
            if (!vv.equals(v)) continue;
            return i;
        }
        int pos = this.m_const_list.size();
        this.m_const_list.add(v);
        return pos;
    }

    public int alloc_stack_identifier() {
        int ret = this.m_stackpos;
        ArrayList<block_identifiers> list = this.m_block_identifiers_stack.get(this.m_block_identifiers_stack.size() - 1);
        list.add(new block_identifiers("", this.m_stackpos));
        ++this.m_stackpos;
        if (this.m_stackpos > this.m_maxstackpos) {
            this.m_maxstackpos = this.m_stackpos;
        }
        return ret;
    }

    public int getvariable(String name) {
        for (int i = this.m_block_identifiers_stack.size() - 1; i >= 0; --i) {
            ArrayList<block_identifiers> list = this.m_block_identifiers_stack.get(i);
            for (int j = 0; j < list.size(); ++j) {
                if (!name.equals(list.get((int)j).m_name)) continue;
                return list.get((int)j).m_pos;
            }
        }
        return -1;
    }

    public int getcontaineraddr(long con, long key) {
        for (int i = 0; i < this.m_containeraddr_list.size(); ++i) {
            container_addr pc = this.m_containeraddr_list.get(i);
            if (con != pc.m_con || key != pc.m_key) continue;
            return i;
        }
        int pos = this.m_containeraddr_list.size();
        container_addr tmp = new container_addr();
        tmp.m_con = con;
        tmp.m_key = key;
        this.m_containeraddr_list.add(tmp);
        return pos;
    }

    public void output(String filename, String packagename, String name, func_binary bin) {
        int i;
        bin.m_filename = filename;
        bin.m_packagename = packagename;
        bin.m_name = name;
        bin.m_maxstack = this.m_maxstackpos;
        bin.m_buff = new long[this.m_byte_code_list.size()];
        for (i = 0; i < this.m_byte_code_list.size(); ++i) {
            bin.m_buff[i] = this.m_byte_code_list.get(i);
        }
        bin.m_lineno_buff = new int[this.m_byte_lineno_list.size()];
        for (i = 0; i < this.m_byte_lineno_list.size(); ++i) {
            bin.m_lineno_buff[i] = this.m_byte_lineno_list.get(i);
        }
        bin.m_const_list = new variant[this.m_const_list.size()];
        for (i = 0; i < this.m_const_list.size(); ++i) {
            bin.m_const_list[i] = this.m_const_list.get(i);
        }
        bin.m_container_addr_list = new container_addr[this.m_containeraddr_list.size()];
        for (i = 0; i < this.m_containeraddr_list.size(); ++i) {
            bin.m_container_addr_list[i] = this.m_containeraddr_list.get(i);
        }
        bin.m_debug_stack_variant_info = new stack_variant_info[this.m_debug_block_identifiers_list.size()];
        for (i = 0; i < this.m_debug_block_identifiers_list.size(); ++i) {
            bin.m_debug_stack_variant_info[i] = this.m_debug_block_identifiers_list.get(i);
        }
        ++bin.m_fresh;
        types.log(this.m_f, "codegen out %s %d", name, this.m_maxstackpos);
    }

    class block_identifiers {
        public String m_name;
        public int m_pos;

        public block_identifiers(String m_name, int m_pos) {
            this.m_name = m_name;
            this.m_pos = m_pos;
        }
    }
}

