/*
 * Decompiled with CFR 0.152.
 */
package com.github.ethancommitpush.feign;

import com.github.ethancommitpush.feign.annotation.FeignClient;
import com.github.ethancommitpush.feign.decoder.CustomErrorDecoder;
import feign.Client;
import feign.Feign;
import feign.Logger;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.httpclient.ApacheHttpClient;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import java.beans.Introspector;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class FeignClientsRegistrar
implements ImportBeanDefinitionRegistrar,
ResourceLoaderAware,
BeanFactoryAware,
EnvironmentAware {
    private static final String BASE_PACKAGES_KEY = "feign.base-packages";
    private static final String LOG_LEVEL_KEY = "feign.log-level";
    private Environment environment;
    private ResourceLoader resourceLoader;
    private BeanFactory beanFactory;

    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        this.registerFeignClients();
    }

    public void registerFeignClients() {
        ClassPathScanningCandidateComponentProvider scanner = this.getScanner();
        scanner.setResourceLoader(this.resourceLoader);
        AnnotationTypeFilter annotationTypeFilter = new AnnotationTypeFilter(FeignClient.class);
        scanner.addIncludeFilter((TypeFilter)annotationTypeFilter);
        List basePackages = Optional.ofNullable(this.environment.getProperty(BASE_PACKAGES_KEY)).map(s -> Arrays.asList(s.split("\\,"))).orElse(Collections.emptyList());
        String logLevel = Optional.ofNullable(this.environment.getProperty(LOG_LEVEL_KEY)).orElse(Logger.Level.BASIC.name());
        basePackages.stream().map(p -> scanner.findCandidateComponents(p)).flatMap(Collection::stream).filter(bd -> bd instanceof AnnotatedBeanDefinition).map(bd -> (AnnotatedBeanDefinition)bd).map(abd -> abd.getMetadata()).filter(meta -> meta.isInterface()).forEach(meta -> {
            Map attributes = meta.getAnnotationAttributes(FeignClient.class.getCanonicalName());
            this.registerFeignClient(meta.getClassName(), attributes, logLevel);
        });
    }

    private void registerFeignClient(String className, Map<String, Object> attributes, String logLevel) {
        String shortClassName = ClassUtils.getShortName((String)className);
        String beanName = Introspector.decapitalize(shortClassName);
        Encoder encoder = this.getEncoder(attributes);
        Class<?> apiType = null;
        try {
            apiType = Class.forName(className);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object bean = this.feignBuild(apiType, this.resolve((String)attributes.get("url")), encoder, logLevel);
        ((ConfigurableListableBeanFactory)this.beanFactory).registerSingleton(beanName, bean);
    }

    private <T> T feignBuild(Class<T> apiType, String url, Encoder encoder, String logLevel) {
        Feign.Builder builder = Feign.builder().client((Client)new ApacheHttpClient((HttpClient)this.getHttpClient())).errorDecoder((ErrorDecoder)new CustomErrorDecoder()).decoder((Decoder)new JacksonDecoder()).logger((Logger)new Logger.ErrorLogger()).logLevel(Logger.Level.valueOf((String)logLevel));
        builder.encoder((Encoder)(encoder != null ? encoder : new JacksonEncoder()));
        return (T)builder.target(apiType, url);
    }

    private CloseableHttpClient getHttpClient() {
        CloseableHttpClient httpClient = null;
        try {
            TrustStrategy acceptingTrustStrategy = (chain, authType) -> true;
            SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)acceptingTrustStrategy).build();
            SSLConnectionSocketFactory csf = new SSLConnectionSocketFactory(sslContext);
            httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)csf).build();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return httpClient;
    }

    private Encoder getEncoder(Map<String, Object> attributes) {
        if (attributes.get("encoder") == null) {
            return null;
        }
        Encoder encoder = null;
        try {
            encoder = (Encoder)((Class)attributes.get("encoder")).newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return encoder;
    }

    private String resolve(String value) {
        if (StringUtils.hasText((String)value)) {
            return this.environment.resolvePlaceholders(value);
        }
        return value;
    }

    private ClassPathScanningCandidateComponentProvider getScanner() {
        return new ClassPathScanningCandidateComponentProvider(false, this.environment){

            protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
                if (!beanDefinition.getMetadata().isIndependent()) {
                    return false;
                }
                return !beanDefinition.getMetadata().isAnnotation();
            }
        };
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

