/*
 * Decompiled with CFR 0.152.
 */
package com.github.ethancommitpush.feign;

import com.github.ethancommitpush.feign.FeignClientsProperties;
import com.github.ethancommitpush.feign.FeignClientsRegistrar;
import com.github.ethancommitpush.feign.annotation.FeignClient;
import com.github.ethancommitpush.feign.decoder.CustomErrorDecoder;
import feign.Client;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.httpclient.ApacheHttpClient;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import javax.net.ssl.SSLContext;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={FeignClient.class})
@Import(value={FeignClientsRegistrar.class})
@EnableConfigurationProperties(value={FeignClientsProperties.class})
public class FeignClientsAutoConfiguration
implements BeanFactoryAware {
    private BeanFactory beanFactory;
    private final FeignClientsProperties properties;

    public FeignClientsAutoConfiguration(FeignClientsProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean(name={"feignErrorDecoder"})
    public ErrorDecoder feignErrorDecoder() {
        return new CustomErrorDecoder();
    }

    @Bean
    @ConditionalOnMissingBean(name={"feignDecoder"})
    public Decoder feignDecoder() {
        return new JacksonDecoder();
    }

    @Bean
    @ConditionalOnMissingBean(name={"feignEncoder"})
    public Encoder feignEncoder() {
        return new JacksonEncoder();
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    @Bean
    @ConditionalOnMissingBean(name={"feignClient"})
    public Client feignClient() {
        return new ApacheHttpClient((HttpClient)this.getHttpClient());
    }

    private CloseableHttpClient getHttpClient() {
        CloseableHttpClient httpClient = null;
        try {
            TrustStrategy acceptingTrustStrategy = (chain, authType) -> true;
            SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)acceptingTrustStrategy).build();
            SSLConnectionSocketFactory csf = new SSLConnectionSocketFactory(sslContext);
            httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)csf).build();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return httpClient;
    }
}

