/*
 * Decompiled with CFR 0.152.
 */
package com.github.ethancommitpush.feign;

import com.github.ethancommitpush.feign.FeignClientsProperties;
import com.github.ethancommitpush.feign.FeignConfigurationUtils;
import feign.Client;
import feign.Feign;
import feign.Logger;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.slf4j.Slf4jLogger;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class FeignClientsFactory<T>
implements FactoryBean<Object>,
BeanFactoryAware,
EnvironmentAware {
    private static final Logger log = LoggerFactory.getLogger(FeignClientsFactory.class);
    private BeanFactory beanFactory;
    private Environment environment;
    private Class<T> apiType;
    private Map<String, Object> attributes;
    @Autowired
    private Client feignClient;
    @Autowired
    private Encoder feignEncoder;
    @Autowired
    private Decoder feignDecoder;
    @Autowired
    private ErrorDecoder feignErrorDecoder;
    @Autowired
    private FeignClientsProperties properties;

    public Object getObject() throws Exception {
        T r = this.feignBuild();
        log.debug("{} feign client: instance is {}, url is {}", new Object[]{this.apiType, r, this.getUrl()});
        return r;
    }

    private T feignBuild() {
        Feign.Builder builder = Feign.builder();
        Client client = this.resolveClient();
        log.debug("{} feign client {}: http client is {}", this.apiType, (Object)client);
        if (client != null) {
            builder.client(client);
        }
        Encoder encoder = this.resolveEncoder();
        log.debug("{} feign client {}: encoder is {}", this.apiType, (Object)encoder);
        if (encoder != null) {
            builder.encoder(encoder);
        }
        Decoder decoder = this.resolveDecoder();
        log.debug("{} feign client {}: decoder is {}", this.apiType, (Object)decoder);
        if (decoder != null) {
            builder.decoder(decoder);
        }
        feign.Logger logger = this.resolveLogger();
        log.debug("{} feign client {}: logger is {}", this.apiType, (Object)logger);
        if (logger != null) {
            builder.logger(logger);
        }
        Logger.Level logLevel = this.properties.getLogLevel();
        log.debug("{} feign client {}: logger level is {}", this.apiType, (Object)logLevel);
        builder.logLevel(logLevel);
        ErrorDecoder errorDecoder = this.resolveErrorDecoder();
        log.debug("{} feign client {}: error decoder is {}", this.apiType, (Object)errorDecoder);
        if (errorDecoder != null) {
            builder.errorDecoder(errorDecoder);
        }
        return (T)builder.target(this.apiType, this.getUrl());
    }

    public feign.Logger resolveLogger() {
        switch (this.properties.getLoggerType()) {
            case SYSTEM_ERR: {
                return new Logger.ErrorLogger();
            }
            case JUL: {
                return new Logger.JavaLogger(this.apiType);
            }
            case NO_OP: {
                return new Logger.NoOpLogger();
            }
            case SLF4J: {
                return new Slf4jLogger(this.apiType);
            }
        }
        return null;
    }

    public String getUrl() {
        return this.resolveAttribute((String)this.attributes.get("url"));
    }

    public Class<?> getObjectType() {
        return this.apiType;
    }

    public Client resolveClient() {
        Class clientClass = (Class)this.attributes.get("clientClass");
        String clientBeanName = (String)this.attributes.get("client");
        Client client = FeignConfigurationUtils.resolveClient(this.beanFactory, clientBeanName, clientClass);
        if (client != null) {
            return client;
        }
        return this.feignClient;
    }

    public Encoder resolveEncoder() {
        Class encoderClass = (Class)this.attributes.get("encoderClass");
        String encoderBeanName = (String)this.attributes.get("encoder");
        Encoder encoder = FeignConfigurationUtils.resolveEncoder(this.beanFactory, encoderBeanName, encoderClass);
        if (encoder != null) {
            return encoder;
        }
        return this.feignEncoder;
    }

    public Decoder resolveDecoder() {
        Class decoderClass = (Class)this.attributes.get("decoderClass");
        String decoderBeanName = (String)this.attributes.get("decoder");
        Decoder decoder = FeignConfigurationUtils.resolveDecoder(this.beanFactory, decoderBeanName, decoderClass);
        if (decoder != null) {
            return decoder;
        }
        return this.feignDecoder;
    }

    public ErrorDecoder resolveErrorDecoder() {
        Class errorDecoderClass = (Class)this.attributes.get("errorDecoderClass");
        String errorDecoderBeanName = (String)this.attributes.get("errorDecoder");
        ErrorDecoder errorDecoder = FeignConfigurationUtils.resolveErrorDecoder(this.beanFactory, errorDecoderBeanName, errorDecoderClass);
        if (errorDecoder != null) {
            return errorDecoder;
        }
        return this.feignErrorDecoder;
    }

    public String resolveAttribute(String value) {
        if (StringUtils.hasText((String)value)) {
            return this.environment.resolvePlaceholders(value);
        }
        return value;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public Class<T> getApiType() {
        return this.apiType;
    }

    public void setApiType(Class<T> apiType) {
        this.apiType = apiType;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public void setProperties(FeignClientsProperties properties) {
        this.properties = properties;
    }
}

