/*
 * Decompiled with CFR 0.152.
 */
package com.github.ethancommitpush.feign;

import com.github.ethancommitpush.feign.FeignClientsFactory;
import com.github.ethancommitpush.feign.annotation.FeignClient;
import java.beans.Introspector;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;

public class FeignClientsRegistrar
implements ImportBeanDefinitionRegistrar,
ResourceLoaderAware,
EnvironmentAware {
    private static final String BASE_PACKAGES_KEY = "feign.base-packages";
    private Environment environment;
    private ResourceLoader resourceLoader;

    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        this.registerFeignClients(registry);
    }

    public void registerFeignClients(BeanDefinitionRegistry registry) {
        ClassPathScanningCandidateComponentProvider scanner = this.getScanner();
        scanner.setResourceLoader(this.resourceLoader);
        AnnotationTypeFilter annotationTypeFilter = new AnnotationTypeFilter(FeignClient.class);
        scanner.addIncludeFilter((TypeFilter)annotationTypeFilter);
        List basePackages = Optional.ofNullable(this.environment.getProperty(BASE_PACKAGES_KEY)).map(s -> Arrays.asList(s.split("\\,"))).orElse(Collections.emptyList());
        basePackages.stream().map(p -> scanner.findCandidateComponents(p)).flatMap(Collection::stream).filter(bd -> bd instanceof AnnotatedBeanDefinition).map(bd -> (AnnotatedBeanDefinition)bd).map(abd -> abd.getMetadata()).filter(meta -> meta.isInterface()).forEach(meta -> {
            Map attributes = meta.getAnnotationAttributes(FeignClient.class.getCanonicalName());
            this.registerFeignClient(registry, meta.getClassName(), attributes);
        });
    }

    private void registerFeignClient(BeanDefinitionRegistry registry, String className, Map<String, Object> attributes) {
        String shortClassName = ClassUtils.getShortName((String)className);
        String beanName = Introspector.decapitalize(shortClassName);
        Class<?> apiType = null;
        try {
            apiType = Class.forName(className);
        }
        catch (Exception exception) {
            // empty catch block
        }
        BeanDefinitionBuilder definition = BeanDefinitionBuilder.genericBeanDefinition(FeignClientsFactory.class);
        definition.addPropertyValue("apiType", apiType);
        definition.addPropertyValue("attributes", attributes);
        definition.setAutowireMode(1);
        AbstractBeanDefinition beanDefinition = definition.getBeanDefinition();
        beanDefinition.setAttribute("factoryBeanObjectType", (Object)className);
        BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)beanDefinition, beanName);
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)registry);
    }

    private ClassPathScanningCandidateComponentProvider getScanner() {
        return new ClassPathScanningCandidateComponentProvider(false, this.environment){

            protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
                if (!beanDefinition.getMetadata().isIndependent()) {
                    return false;
                }
                return !beanDefinition.getMetadata().isAnnotation();
            }
        };
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

