/*
 * Decompiled with CFR 0.152.
 */
package com.github.ethancommitpush.feign;

import feign.Client;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.util.StringUtils;

public class FeignConfigurationUtils {
    public static <T> T resolveOverrideableBean(Class<T> hint, BeanFactory beanFactory, String beanName, Class<?> beanClass) {
        boolean hasClass;
        boolean hasBeanName = !StringUtils.isEmpty((Object)beanName);
        boolean bl = hasClass = beanClass != null && beanClass != Void.TYPE;
        if (hasBeanName && hasClass) {
            throw new IllegalArgumentException(String.format("feign client %s bean is exclusive with %s class", hint.getSimpleName(), hint.getSimpleName()));
        }
        if (hasBeanName) {
            return (T)beanFactory.getBean(beanName, hint);
        }
        if (hasClass) {
            try {
                return (T)beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return null;
    }

    public static Decoder resolveDecoder(BeanFactory beanFactory, String decoderBeanName, Class<? extends Decoder> decoderClass) {
        return FeignConfigurationUtils.resolveOverrideableBean(Decoder.class, beanFactory, decoderBeanName, decoderClass);
    }

    public static Encoder resolveEncoder(BeanFactory beanFactory, String encoderBeanName, Class<? extends Encoder> encoderClass) {
        return FeignConfigurationUtils.resolveOverrideableBean(Encoder.class, beanFactory, encoderBeanName, encoderClass);
    }

    public static ErrorDecoder resolveErrorDecoder(BeanFactory beanFactory, String errorDecoderBeanName, Class<? extends ErrorDecoder> errorDecoderClass) {
        return FeignConfigurationUtils.resolveOverrideableBean(ErrorDecoder.class, beanFactory, errorDecoderBeanName, errorDecoderClass);
    }

    public static Client resolveClient(BeanFactory beanFactory, String clientBeanName, Class<? extends Client> clientClass) {
        return FeignConfigurationUtils.resolveOverrideableBean(Client.class, beanFactory, clientBeanName, clientClass);
    }
}

