/*
 * Decompiled with CFR 0.152.
 */
package com.github.expdev07.commy.bungee;

import com.github.expdev07.commy.bungee.BungeeConnection;
import com.github.expdev07.commy.core.Commy;
import com.github.expdev07.commy.core.Connection;
import com.github.expdev07.commy.core.Message;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.event.PluginMessageEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.event.EventHandler;

public class BungeeCommy
extends Commy<ServerInfo> {
    private Plugin plugin;

    public BungeeCommy(Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public BungeeCommy setup() {
        this.plugin.getProxy().registerChannel("Commy");
        this.plugin.getProxy().getPluginManager().registerListener(this.plugin, (Listener)new MessageListener(this.plugin, this));
        return this;
    }

    @Override
    public void sendMessage(ServerInfo target, String tag, String message) {
        this.getConnection(target).sendMessage(tag, message);
    }

    @Override
    public void sendMessage(ServerInfo target, Message message) {
        this.getConnection(target).sendMessage(message);
    }

    @Override
    public Connection<ServerInfo> getConnection(ServerInfo target) {
        return new BungeeConnection("Commy", target);
    }

    private static ServerInfo findServerWithPort(ProxyServer proxy, int port) {
        return proxy.getServers().values().stream().filter(info -> info.getAddress().getPort() == port).findFirst().orElse(null);
    }

    private static class MessageListener
    implements Listener {
        private Plugin plugin;
        private BungeeCommy commy;

        public MessageListener(Plugin plugin, BungeeCommy commy) {
            this.plugin = plugin;
            this.commy = commy;
        }

        @EventHandler
        public void onPluginMessageReceived(PluginMessageEvent event) {
            if (!event.getTag().equals("Commy")) {
                return;
            }
            ServerInfo server = BungeeCommy.findServerWithPort(this.plugin.getProxy(), event.getSender().getAddress().getPort());
            if (server == null) {
                this.plugin.getLogger().warning("Could not identify source of message. Proceeding anyways.");
            }
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])event.getData());
            this.commy.handleMessage(this.commy.getConnection(server), in.readUTF(), in.readUTF());
            event.setCancelled(true);
        }
    }
}

