/*
 * Decompiled with CFR 0.152.
 */
package com.github.expdev07.commy.core;

import com.github.expdev07.commy.core.Connection;
import com.github.expdev07.commy.core.Message;
import com.github.expdev07.commy.core.handler.MessageHandler;
import java.util.HashMap;
import java.util.Map;

public abstract class Commy<T> {
    public static final String CHANNEL_ID = "Commy";
    private MessageHandler<T> defaultHandler = null;
    private Map<String, MessageHandler<T>> handlers = new HashMap<String, MessageHandler<T>>();

    public void setDefaultHandler(MessageHandler<T> handler) {
        this.defaultHandler = handler;
    }

    public void addHandler(String tag, MessageHandler<T> handler) {
        this.handlers.put(tag.toLowerCase(), handler);
    }

    protected void handleMessage(Connection<T> sender, String tag, String message) {
        MessageHandler<T> handler = this.handlers.get(tag);
        if (handler == null) {
            if (this.defaultHandler != null) {
                this.defaultHandler.handle(sender, tag, message);
            }
            return;
        }
        handler.handle(sender, tag, message);
    }

    public abstract Commy setup();

    public abstract void sendMessage(T var1, String var2, String var3);

    public abstract void sendMessage(T var1, Message var2);

    public abstract Connection<T> getConnection(T var1);
}

