/*
 * Decompiled with CFR 0.152.
 */
package com.github.falloutfire.htmlparser;

import com.github.falloutfire.htmlparser.Entity.Page;
import com.github.falloutfire.htmlparser.ParserStrategy.Impl.ArticleBlockStrategy;
import com.github.falloutfire.htmlparser.ParserStrategy.Impl.DivContentStrategy;
import com.github.falloutfire.htmlparser.ParserStrategy.ParserStrategy;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;

public class JHtmlParser {
    private Page page;
    private ParserStrategy parserStrategy;
    private String userAgent;

    public JHtmlParser(URI uri, String userAgent) {
        this.userAgent = userAgent;
        this.page = new Page(uri, this.setDomainName(uri));
    }

    public JHtmlParser(String url, String userAgent) throws URISyntaxException {
        URI uri = new URI(url);
        this.userAgent = userAgent;
        this.page = new Page(uri, this.setDomainName(uri));
    }

    private String setDomainName(URI uri) {
        return uri.toString().startsWith("www.") ? "https://".concat(uri.toString().substring(4)) : uri.toString();
    }

    public final void init() throws IOException {
        this.parse();
    }

    private void parse() throws IOException {
        Document document = Jsoup.connect((String)this.page.getUri().toString()).userAgent(this.userAgent).referrer("http://www.google.com").get();
        this.page.setDocument(document);
        Elements article = document.select("article");
        if (!article.isEmpty()) {
            this.page.setArticle(article);
            System.out.println("article " + this.page.getDomain());
            this.parserStrategy = new ArticleBlockStrategy();
            this.parserStrategy.parse(this.page);
            return;
        }
        article = document.select("div[class*=article]");
        if (!article.isEmpty()) {
            this.page.setArticle(article);
            System.out.println("div article " + this.page.getDomain());
            this.parserStrategy = new DivContentStrategy();
            this.parserStrategy.parse(this.page);
            return;
        }
        article = document.select("div[id~=(?i)([Bb](ody|log)(|[ _-])[Cc]ontent)(?i)]");
        if (!article.isEmpty()) {
            this.page.setArticle(article);
            System.out.println("id " + this.page.getDomain());
            this.parserStrategy = new DivContentStrategy();
            this.parserStrategy.parse(this.page);
            return;
        }
        article = document.select("div[class~=(?i)([Bb](ody|log)(|[ _-])[Cc]ontent)(?i)]");
        if (!article.isEmpty()) {
            this.page.setArticle(article);
            System.out.println("class " + this.page.getDomain());
            this.parserStrategy = new DivContentStrategy();
            this.parserStrategy.parse(this.page);
            return;
        }
        article = document.select("div[class~=(?i)([Dd]etail(|[ _-])[Cc]ontent)(?i)]");
        if (!article.isEmpty()) {
            this.page.setArticle(article);
            System.out.println("detail " + this.page.getDomain());
            this.parserStrategy = new DivContentStrategy();
            this.parserStrategy.parse(this.page);
            return;
        }
    }

    public final String outerHtml() {
        return this.page.getArticle().outerHtml();
    }

    public Page getPage() {
        return this.page;
    }

    public void setPage(Page page) {
        this.page = page;
    }
}

