/*
 * Decompiled with CFR 0.152.
 */
package com.github.falloutfire.htmlparser.ParserStrategy;

import com.github.falloutfire.htmlparser.Entity.Page;
import org.jsoup.nodes.Node;

public class CleaningContent {
    public static void clean(Page page) {
        CleaningContent.repairImages(page);
        CleaningContent.repairSrc(page);
        CleaningContent.removeTrashBlock(page);
        CleaningContent.removeScripts(page);
    }

    private static void removeTrashBlock(Page page) {
        page.getArticle().select("div[class~=(?i)meta(?i)]").forEach(Node::remove);
        page.getArticle().select("div[class~=(?i)share(?i)]").forEach(Node::remove);
        page.getArticle().select("div[class~=(?i)comment(?i)]").forEach(Node::remove);
        page.getArticle().select("div[class~=(?i)widgets(?i)]").forEach(Node::remove);
        page.getArticle().select("div[class~=(?i)favorite(?i)]").forEach(Node::remove);
        page.getArticle().select("div[class~=(?i)audio(?i)]").forEach(Node::remove);
        page.getArticle().select("div[class~=(?i)(T|t)oolbar(?i)]").forEach(Node::remove);
        page.getArticle().select("div, p, pre, ul").forEach(element -> {
            if (element.children().isEmpty()) {
                element.tagName("p");
                element.removeAttr("style");
                element.removeAttr("width");
                element.removeAttr("height");
            }
        });
    }

    private static void repairSrc(Page page) {
        page.getArticle().select("[src],[href]").forEach(element -> {
            if (!element.attr("href").startsWith("http")) {
                element.attr("href", element.attr("href").startsWith("//") ? "https:" + element.attr("href") : page.getDomain() + element.attr("href"));
            }
            if (!element.attr("src").startsWith("http")) {
                element.attr("src", element.attr("src").startsWith("//") ? "https:" + element.attr("src") : page.getDomain() + element.attr("src"));
            }
        });
    }

    private static void removeScripts(Page page) {
        page.getArticle().select("script, noscript").forEach(Node::remove);
    }

    private static void repairImages(Page page) {
        page.getArticle().select("div[class~=(((?i))image(?i))]").forEach(element -> {
            if (element.hasAttr("data-image-src")) {
                element.tagName("img");
                element.attr("src", element.attr("data-image-src"));
                element.attr("style", "width: 100%;height: auto; display: block;");
            }
        });
    }
}

