/*
 * Decompiled with CFR 0.152.
 */
package com.github.fangjinuo.sqlhelper.batchinsert;

import com.github.fangjinuo.sqlhelper.batchinsert.BatchInsertResult;
import com.github.fangjinuo.sqlhelper.batchinsert.BatchInsertTask;
import com.github.fangjinuo.sqlhelper.batchinsert.BatchInsertTaskFactory;
import com.github.fangjinuo.sqlhelper.batchinsert.ConnectionFactory;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchInsertExecutor {
    private static final Logger logger = LoggerFactory.getLogger(BatchInsertExecutor.class);
    public static final DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private ConnectionFactory connFactory = null;
    private Random random = new Random(1000L);
    protected Calendar start;
    private long end;
    private ExecutorService executor;
    private List<Future<BatchInsertResult>> futures = new LinkedList<Future<BatchInsertResult>>();
    private BatchInsertTaskFactory taskFactory;

    public BatchInsertExecutor(long start, long end, int concurrency, ConnectionFactory connectionFactory) {
        this.start = Calendar.getInstance();
        this.start.setTimeInMillis(start);
        this.end = end;
        this.connFactory = connectionFactory;
        concurrency = concurrency > 0 ? concurrency : 1;
        this.executor = Executors.newFixedThreadPool(concurrency);
    }

    public void setConnectionFactory(ConnectionFactory connFactory) {
        this.connFactory = connFactory;
    }

    public void setTaskFactory(BatchInsertTaskFactory taskFactory) {
        this.taskFactory = taskFactory;
    }

    public void setStartTimeAsZero() {
        this.start.set(10, 0);
        this.start.set(12, 0);
        this.start.set(13, 0);
    }

    protected long nextTime() {
        this.start.add(10, 1);
        return this.start.getTimeInMillis();
    }

    public void startup() {
        logger.info("startup() insert time: {}", (Object)df.format(new Date(System.currentTimeMillis())));
        long time = this.end;
        while ((time = this.nextTime()) <= this.end) {
            logger.info(df.format(new Date(time)));
            Object task = this.taskFactory.createTask(df.format(new Date(time)), this.random.nextInt());
            this.submitTask((BatchInsertTask)task);
        }
    }

    private void submitTask(BatchInsertTask task) {
        task.setConnFactory(this.connFactory);
        this.futures.add(this.executor.submit(task));
    }

    public void shutdown() throws InterruptedException, ExecutionException {
        try {
            for (int i = 0; i < this.futures.size(); ++i) {
                BatchInsertResult result = this.futures.get(i).get();
                if (result.getExpectResult() == result.getExpectResult()) {
                    logger.info(result.getTime() + ": success");
                    continue;
                }
                logger.warn(result.getTime() + ": fail");
            }
        }
        finally {
            if (this.executor != null && !this.executor.isShutdown() && !this.executor.isTerminated()) {
                this.executor.shutdownNow();
            }
            logger.info("shutdown() insert time: {}", (Object)df.format(new Date(System.currentTimeMillis())));
        }
    }
}

