/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.batchinsert;

import com.jn.sqlhelper.batchinsert.ConnectionConfiguration;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public class ConnectionFactory {
    private ConnectionConfiguration connectionConfiguration;

    public ConnectionFactory(String driver, String url, String user, String password, Properties driverProps) {
        this(new ConnectionConfiguration(driver, url, user, password, driverProps));
    }

    public ConnectionFactory(ConnectionConfiguration connConfig) {
        this.connectionConfiguration = connConfig;
        if (connConfig.getDriver() != null) {
            try {
                Class.forName(connConfig.getDriver(), false, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void setConnectionConfiguration(ConnectionConfiguration connectionConfiguration) {
        this.connectionConfiguration = connectionConfiguration;
    }

    public Connection getConnection() {
        try {
            if (this.connectionConfiguration.getDriver() != null) {
                try {
                    Class.forName(this.connectionConfiguration.getDriver(), true, Thread.currentThread().getContextClassLoader());
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.connectionConfiguration.getDriverProps() != null && !this.connectionConfiguration.getDriverProps().isEmpty()) {
                return DriverManager.getConnection(this.connectionConfiguration.getUrl(), this.connectionConfiguration.getDriverProps());
            }
            DriverManager.getConnection(this.connectionConfiguration.getUrl(), this.connectionConfiguration.getUser(), this.connectionConfiguration.getPassword());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }
}

