/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.cli.commands;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.StringMap;
import com.jn.langx.util.function.Consumer2;
import com.jn.sqlhelper.common.connection.ConnectionConfiguration;
import java.util.Map;
import java.util.Properties;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;

@ShellComponent(value="connection")
public class JdbcConnectionCommands {
    @ShellMethod(key={"create"})
    public ConnectionConfiguration addConnection(@NonNull String driver, @NonNull String url, @NonNull String username, @Nullable String password, @Nullable String props) {
        Preconditions.checkNotNull((Object)driver);
        Preconditions.checkNotNull((Object)url);
        Preconditions.checkNotNull((Object)username);
        StringMap propsMap = new StringMap(props, "=", "&");
        final Properties properties = new Properties();
        Collects.forEach((Map)propsMap, (Consumer2)new Consumer2<String, String>(){

            public void accept(String key, String value) {
                properties.setProperty(key, value);
            }
        });
        ConnectionConfiguration configuration = new ConnectionConfiguration(driver, url, username, password, properties);
        return configuration;
    }
}

