/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.compute;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.net.HostAndPort;
import com.google.common.net.InetAddresses;
import java.util.Map;
import java.util.Random;
import org.jclouds.cloudstack.CloudStackContext;
import org.jclouds.cloudstack.compute.options.CloudStackTemplateOptions;
import org.jclouds.cloudstack.compute.strategy.CloudStackComputeServiceAdapter;
import org.jclouds.cloudstack.domain.IPForwardingRule;
import org.jclouds.cloudstack.domain.ServiceOffering;
import org.jclouds.cloudstack.domain.Template;
import org.jclouds.cloudstack.domain.VirtualMachine;
import org.jclouds.cloudstack.internal.BaseCloudStackApiLiveTest;
import org.jclouds.cloudstack.predicates.TemplatePredicates;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.functions.DefaultCredentialsFromImageOrOverridingCredentials;
import org.jclouds.compute.strategy.PrioritizeCredentialsFromTemplate;
import org.jclouds.domain.Credentials;
import org.jclouds.ssh.SshKeys;
import org.testng.Assert;
import org.testng.annotations.AfterGroups;
import org.testng.annotations.BeforeGroups;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="CloudStackComputeServiceAdapterLiveTest")
public class CloudStackComputeServiceAdapterLiveTest
extends BaseCloudStackApiLiveTest {
    private CloudStackComputeServiceAdapter adapter;
    private ComputeServiceAdapter.NodeAndInitialCredentials<VirtualMachine> vm;
    private String keyPairName;
    private Map<String, String> keyPair;
    Map<String, Credentials> credentialStore = Maps.newLinkedHashMap();
    private static final PrioritizeCredentialsFromTemplate prioritizeCredentialsFromTemplate = new PrioritizeCredentialsFromTemplate((Function)new DefaultCredentialsFromImageOrOverridingCredentials());

    @Override
    @BeforeGroups(groups={"live"})
    public void setupContext() {
        super.setupContext();
        this.adapter = (CloudStackComputeServiceAdapter)this.context.utils().injector().getInstance(CloudStackComputeServiceAdapter.class);
        this.keyPairName = this.prefix + "-adapter-test-keypair";
        this.keyPair = SshKeys.generate();
        this.client.getSSHKeyPairApi().deleteSSHKeyPair(this.keyPairName);
        this.client.getSSHKeyPairApi().registerSSHKeyPair(this.keyPairName, this.keyPair.get("public"));
    }

    @Test
    public void testListLocations() {
        Assert.assertFalse((boolean)Iterables.isEmpty((Iterable)this.adapter.listLocations()));
    }

    @Test
    public void testCreateNodeWithGroupEncodedIntoName() {
        String group = this.prefix + "-foo";
        String name = group + "-node-" + new Random().nextInt();
        org.jclouds.compute.domain.Template template = ((CloudStackContext)this.view).getComputeService().templateBuilder().build();
        if (!this.client.getTemplateApi().getTemplateInZone(template.getImage().getId(), template.getLocation().getId()).isPasswordEnabled()) {
            ((CloudStackTemplateOptions)template.getOptions().as(CloudStackTemplateOptions.class)).keyPair(this.keyPairName);
        }
        this.vm = this.adapter.createNodeWithGroupEncodedIntoName(group, name, template);
        Assert.assertEquals((String)((VirtualMachine)this.vm.getNode()).getDisplayName(), (String)name);
        IPForwardingRule rule = (IPForwardingRule)Iterables.getFirst((Iterable)this.client.getNATApi().getIPForwardingRulesForVirtualMachine(((VirtualMachine)this.vm.getNode()).getId()), null);
        String address = rule != null ? rule.getIPAddress() : ((VirtualMachine)this.vm.getNode()).getIPAddress();
        this.loginCredentials = prioritizeCredentialsFromTemplate.apply(template, this.vm.getCredentials());
        assert (InetAddresses.isInetAddress((String)address)) : this.vm;
        HostAndPort socket = HostAndPort.fromParts((String)address, (int)22);
        this.checkSSH(socket);
    }

    @Test
    public void testListHardwareProfiles() {
        Iterable profiles = this.adapter.listHardwareProfiles();
        Assert.assertFalse((boolean)Iterables.isEmpty((Iterable)profiles));
        for (ServiceOffering serviceOffering : profiles) {
        }
    }

    @Test
    public void testListImages() {
        Iterable templates = this.adapter.listImages();
        Assert.assertFalse((boolean)Iterables.isEmpty((Iterable)templates));
        for (Template template : templates) {
            assert (TemplatePredicates.isReady().apply((Object)template)) : template;
        }
    }

    @AfterGroups(groups={"live"})
    protected void tearDownContext() {
        if (this.vm != null) {
            this.adapter.destroyNode(this.vm.getNodeId());
        }
        super.tearDownContext();
    }
}

