/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.jclouds.cloudstack.CloudStackContext;
import org.jclouds.cloudstack.domain.AsyncCreateResponse;
import org.jclouds.cloudstack.domain.Tag;
import org.jclouds.cloudstack.features.TagApi;
import org.jclouds.cloudstack.internal.BaseCloudStackExpectTest;
import org.jclouds.cloudstack.options.CreateTagsOptions;
import org.jclouds.cloudstack.options.DeleteTagsOptions;
import org.jclouds.cloudstack.options.ListTagsOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="TagApiExpectTest")
public class TagApiExpectTest
extends BaseCloudStackExpectTest<TagApi> {
    public void testListTagsWhenResponseIs2xx() {
        TagApi client = (TagApi)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"listTags"}).addQueryParam("listAll", new String[]{"true"}).addQueryParam("apiKey", new String[]{"identity"}).addQueryParam("signature", new String[]{"amvtC2a0VHzzDF5SUAIOZpXHd0A="}).addHeader("Accept", new String[]{"application/json"})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/listtagsresponse.json"))).build());
        Assert.assertEquals((Set)client.listTags(new ListTagsOptions[0]), (Set)ImmutableSet.of((Object)Tag.builder().account("admin").domain("ROOT").domainId("79dc06c4-4432-11e4-b70d-000c29e19aa0").key("test-tag").resourceId("54fe1d53-5d73-4184-8b62-948b9d8e08fb").resourceType(Tag.ResourceType.TEMPLATE).value("true").build()));
    }

    public void testListTagsWhenResponseIs404() {
        TagApi client = (TagApi)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"listTags"}).addQueryParam("listAll", new String[]{"true"}).addQueryParam("apiKey", new String[]{"identity"}).addQueryParam("signature", new String[]{"amvtC2a0VHzzDF5SUAIOZpXHd0A="}).addHeader("Accept", new String[]{"application/json"})).build(), HttpResponse.builder().statusCode(404).build());
        Assert.assertEquals((Set)client.listTags(new ListTagsOptions[0]), (Set)ImmutableSet.of());
    }

    public void testCreateTagsWhenResponseIs2xx() {
        TagApi client = (TagApi)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"createTags"}).addQueryParam("resourcetype", new String[]{"Template"}).addQueryParam("resourceids", new String[]{"52d89d5d-6070-4fd4-8131-c6c9ca4b062e"}).addQueryParam("tags[0].key", new String[]{"some-tag"}).addQueryParam("tags[0].value", new String[]{"some-value"}).addQueryParam("apiKey", new String[]{"identity"}).addQueryParam("signature", new String[]{"HDGTKGG9kONEwh5xlLe9R72z+9Q="}).addHeader("Accept", new String[]{"application/json"})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/createtagsresponse.json"))).build());
        AsyncCreateResponse async = client.createTags(CreateTagsOptions.Builder.resourceType((String)"Template").resourceIds(new String[]{"52d89d5d-6070-4fd4-8131-c6c9ca4b062e"}).tags((Map)ImmutableMap.of((Object)"some-tag", (Object)"some-value")));
        Assert.assertEquals((Object)async, (Object)AsyncCreateResponse.builder().jobId("32cfab73-f221-4b2b-a728-a73e924ac95d").build());
    }

    public void testDeleteTagsWhenResponseIs2xx() {
        TagApi client = (TagApi)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"deleteTags"}).addQueryParam("resourcetype", new String[]{"Template"}).addQueryParam("resourceids", new String[]{"52d89d5d-6070-4fd4-8131-c6c9ca4b062e"}).addQueryParam("tags[0].key", new String[]{"some-tag"}).addQueryParam("tags[0].value", new String[]{"some-value"}).addQueryParam("apiKey", new String[]{"identity"}).addQueryParam("signature", new String[]{"inAqWH/GkkGipkZFG5Wfmxa8vOE="}).addHeader("Accept", new String[]{"application/json"})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/deletetagsresponse.json"))).build());
        AsyncCreateResponse async = client.deleteTags(DeleteTagsOptions.Builder.resourceType((String)"Template").resourceIds(new String[]{"52d89d5d-6070-4fd4-8131-c6c9ca4b062e"}).tags((Map)ImmutableMap.of((Object)"some-tag", (Object)"some-value")));
        Assert.assertEquals((Object)async, (Object)AsyncCreateResponse.builder().jobId("32cfab73-f221-4b2b-a728-a73e924ac95d").build());
    }

    @Override
    protected TagApi clientFrom(CloudStackContext context) {
        return context.getApi().getTagApi();
    }
}

