/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.compute.functions;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Set;
import org.jclouds.cloudstack.compute.functions.CloudStackSecurityGroupToSecurityGroup;
import org.jclouds.cloudstack.compute.functions.IngressRuleToIpPermission;
import org.jclouds.cloudstack.domain.IngressRule;
import org.jclouds.cloudstack.domain.SecurityGroup;
import org.jclouds.net.domain.IpProtocol;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="CloudStackSecurityGroupToSecurityGroupTest")
public class CloudStackSecurityGroupToSecurityGroupTest {
    private static final IngressRuleToIpPermission ruleConverter = new IngressRuleToIpPermission();

    @Test
    public void testApply() {
        IngressRule ruleToConvert = IngressRule.builder().id("some-id").account("some-account").securityGroupName("some-group-name").protocol(IpProtocol.TCP.toString()).startPort(10).endPort(20).CIDR("0.0.0.0/0").build();
        SecurityGroup origGroup = SecurityGroup.builder().id("some-id").name("some-group").description("some-description").account("some-account").ingressRules((Set)ImmutableSet.of((Object)ruleToConvert)).build();
        CloudStackSecurityGroupToSecurityGroup parser = this.createGroupParser();
        org.jclouds.compute.domain.SecurityGroup group = parser.apply(origGroup);
        Assert.assertEquals((String)group.getId(), (String)origGroup.getId());
        Assert.assertEquals((String)group.getProviderId(), (String)origGroup.getId());
        Assert.assertEquals((String)group.getName(), (String)origGroup.getName());
        Assert.assertEquals((String)group.getOwnerId(), (String)origGroup.getAccount());
        Assert.assertEquals((Set)group.getIpPermissions(), (Set)ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)origGroup.getIngressRules(), (Function)ruleConverter)));
    }

    private CloudStackSecurityGroupToSecurityGroup createGroupParser() {
        CloudStackSecurityGroupToSecurityGroup parser = new CloudStackSecurityGroupToSecurityGroup((Function)ruleConverter);
        return parser;
    }
}

