/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.compute.functions;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.cloudstack.compute.functions.IngressRuleToIpPermission;
import org.jclouds.cloudstack.domain.IngressRule;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.net.domain.IpProtocol;
import org.testng.Assert;
import org.testng.annotations.Test;

public class IngressRuleToIpPermissionTest {
    @Test
    public void testApplyWithTCP() {
        IngressRule ruleToConvert = IngressRule.builder().id("some-id").account("some-account").securityGroupName("some-group-name").protocol(IpProtocol.TCP.toString()).startPort(10).endPort(20).CIDR("0.0.0.0/0").build();
        IngressRuleToIpPermission converter = new IngressRuleToIpPermission();
        IpPermission convertedPerm = converter.apply(ruleToConvert);
        Assert.assertEquals((Object)convertedPerm.getIpProtocol(), (Object)IpProtocol.fromValue((String)ruleToConvert.getProtocol()));
        Assert.assertEquals((int)convertedPerm.getFromPort(), (int)ruleToConvert.getStartPort());
        Assert.assertEquals((int)convertedPerm.getToPort(), (int)ruleToConvert.getEndPort());
        Assert.assertEquals((Set)convertedPerm.getCidrBlocks(), (Set)ImmutableSet.of((Object)"0.0.0.0/0"));
        Assert.assertEquals((int)convertedPerm.getTenantIdGroupNamePairs().size(), (int)1);
        Assert.assertEquals((int)convertedPerm.getGroupIds().size(), (int)0);
    }
}

