/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.compute.loaders;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.net.UnknownHostException;
import org.easymock.EasyMock;
import org.jclouds.cloudstack.CloudStackApi;
import org.jclouds.cloudstack.compute.loaders.CreateUniqueKeyPair;
import org.jclouds.cloudstack.domain.SshKeyPair;
import org.jclouds.cloudstack.features.SSHKeyPairApi;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="CreateUniqueKeyPairTest")
public class CreateUniqueKeyPairTest {
    @Test
    public void testLoad() throws UnknownHostException {
        final CloudStackApi client = (CloudStackApi)EasyMock.createMock(CloudStackApi.class);
        SSHKeyPairApi keyClient = (SSHKeyPairApi)EasyMock.createMock(SSHKeyPairApi.class);
        SshKeyPair pair = (SshKeyPair)EasyMock.createMock(SshKeyPair.class);
        EasyMock.expect((Object)client.getSSHKeyPairApi()).andReturn((Object)keyClient);
        EasyMock.expect((Object)keyClient.createSSHKeyPair("group-1")).andReturn((Object)pair);
        EasyMock.replay((Object[])new Object[]{client, keyClient});
        CreateUniqueKeyPair parser = (CreateUniqueKeyPair)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind((TypeLiteral)new TypeLiteral<Supplier<String>>(){}).toInstance((Object)Suppliers.ofInstance((Object)"1"));
                this.bind(CloudStackApi.class).toInstance((Object)client);
            }
        }}).getInstance(CreateUniqueKeyPair.class);
        Assert.assertEquals((Object)parser.load("group-1"), (Object)pair);
        EasyMock.verify((Object[])new Object[]{client, keyClient});
    }
}

