/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import org.jclouds.cloudstack.domain.Account;
import org.jclouds.cloudstack.domain.AsyncCreateResponse;
import org.jclouds.cloudstack.domain.AsyncJob;
import org.jclouds.cloudstack.features.GlobalAccountApiLiveTest;
import org.jclouds.cloudstack.internal.BaseCloudStackApiLiveTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="DomainAccountApiLiveTest")
public class DomainAccountApiLiveTest
extends BaseCloudStackApiLiveTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEnableDisableAccount() {
        this.skipIfNotGlobalAdmin();
        Account testAccount = null;
        try {
            testAccount = GlobalAccountApiLiveTest.createTestAccount(this.globalAdminClient, this.prefix);
            AsyncCreateResponse response = this.domainAdminClient.getAccountApi().disableAccount(testAccount.getName(), testAccount.getDomainId(), false);
            Assert.assertNotNull((Object)response);
            Assert.assertTrue((boolean)this.adminJobComplete.apply((Object)response.getJobId()));
            AsyncJob job = this.domainAdminClient.getAsyncJobApi().getAsyncJob(response.getJobId());
            Assert.assertEquals((Object)((Account)job.getResult()).getState(), (Object)Account.State.DISABLED);
            Account updated = this.domainAdminClient.getAccountApi().enableAccount(testAccount.getName(), testAccount.getDomainId());
            Assert.assertNotNull((Object)updated);
            Assert.assertEquals((Object)updated.getState(), (Object)Account.State.ENABLED);
        }
        finally {
            if (testAccount != null) {
                this.globalAdminClient.getAccountApi().deleteAccount(testAccount.getId());
            }
        }
    }
}

