/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jclouds.cloudstack.domain.Domain;
import org.jclouds.cloudstack.internal.BaseCloudStackApiLiveTest;
import org.jclouds.cloudstack.options.ListDomainChildrenOptions;
import org.jclouds.cloudstack.options.ListDomainsOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="DomainDomainApiLiveTest")
public class DomainDomainApiLiveTest
extends BaseCloudStackApiLiveTest {
    @Test
    public void testListDomains() {
        this.skipIfNotDomainAdmin();
        Set domains = this.domainAdminClient.getDomainClient().listDomains(new ListDomainsOptions[0]);
        for (Domain candidate : domains) {
            this.checkDomain(candidate);
        }
    }

    private void checkDomain(Domain domain) {
        Assert.assertNotNull((Object)domain.getId());
        if (domain.getLevel() == 0L) {
            Assert.assertNull((Object)domain.getParentDomainName());
            Assert.assertNull((Object)domain.getParentDomainId());
        } else {
            Assert.assertNotNull((Object)domain.getParentDomainName());
            Assert.assertNotNull((Object)domain.getParentDomainId());
        }
    }

    @Test
    public void testListDomainChildren() {
        this.skipIfNotDomainAdmin();
        Set domains = this.domainAdminClient.getDomainClient().listDomains(new ListDomainsOptions[0]);
        Domain root = this.findRootOfVisibleTree(domains);
        if (domains.size() > 1) {
            Assert.assertTrue((boolean)root.hasChild());
        }
        Set children = this.domainAdminClient.getDomainClient().listDomainChildren(new ListDomainChildrenOptions[]{ListDomainChildrenOptions.Builder.parentDomainId((String)root.getId()).isRecursive(true)});
        Assert.assertEquals((int)(domains.size() - 1), (int)children.size());
        Assert.assertTrue((boolean)Sets.difference((Set)domains, (Set)children).contains((Object)root));
    }

    private Domain findRootOfVisibleTree(Set<Domain> domains) {
        HashSet names = Sets.newHashSet((Iterable)Iterables.transform(domains, (Function)new Function<Domain, String>(){

            public String apply(Domain domain) {
                return domain.getName();
            }
        }));
        for (Domain candidate : domains) {
            if (candidate.getParentDomainId() != null && names.contains(candidate.getParentDomainName())) continue;
            return candidate;
        }
        throw new NoSuchElementException("No root node found in this tree");
    }
}

