/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import java.net.URI;
import org.jclouds.cloudstack.CloudStackContext;
import org.jclouds.cloudstack.domain.Domain;
import org.jclouds.cloudstack.features.GlobalDomainApi;
import org.jclouds.cloudstack.internal.BaseCloudStackExpectTest;
import org.jclouds.cloudstack.options.CreateDomainOptions;
import org.jclouds.cloudstack.options.UpdateDomainOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="GlobalDomainApiExpectTest")
public class GlobalDomainApiExpectTest
extends BaseCloudStackExpectTest<GlobalDomainApi> {
    public void testCreateDomainWhenResponseIs2xx() {
        GlobalDomainApi client = (GlobalDomainApi)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=createDomain&name=test&apiKey=identity&signature=6cxzEo7h63G0hgTTMLm4lGsSDK8%3D")).addHeader("Accept", new String[]{"application/json"})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/createdomainresponse.json"))).build());
        Assert.assertEquals((Object)client.createDomain("test", new CreateDomainOptions[0]), (Object)Domain.builder().id("10").name("test").level(1L).parentDomainId("1").parentDomainName("ROOT").hasChild(false).build());
    }

    public void testCreateDomainWhenResponseIs404() {
        GlobalDomainApi client = (GlobalDomainApi)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=createDomain&name=test&apiKey=identity&signature=6cxzEo7h63G0hgTTMLm4lGsSDK8%3D")).addHeader("Accept", new String[]{"application/json"})).build(), HttpResponse.builder().statusCode(404).build());
        Assert.assertNull((Object)client.createDomain("test", new CreateDomainOptions[0]));
    }

    public void testUpdateDomainWhenResponseIs2xx() {
        GlobalDomainApi client = (GlobalDomainApi)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=updateDomain&id=10&name=test-2&apiKey=identity&signature=5t1eUf2Eyf/aB6qt%2BqIj%2BmcwFIo%3D")).addHeader("Accept", new String[]{"application/json"})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/updatedomainresponse.json"))).build());
        Assert.assertEquals((Object)client.updateDomain("10", new UpdateDomainOptions[]{UpdateDomainOptions.Builder.name((String)"test-2")}), (Object)Domain.builder().id("10").name("test-2").level(1L).parentDomainId("1").parentDomainName("ROOT").hasChild(false).build());
    }

    public void testUpdateDomainWhenResponseIs404() {
        GlobalDomainApi client = (GlobalDomainApi)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=updateDomain&id=10&name=test-2&apiKey=identity&signature=5t1eUf2Eyf/aB6qt%2BqIj%2BmcwFIo%3D")).addHeader("Accept", new String[]{"application/json"})).build(), HttpResponse.builder().statusCode(404).build());
        Assert.assertNull((Object)client.updateDomain("10", new UpdateDomainOptions[]{UpdateDomainOptions.Builder.name((String)"test-2")}));
    }

    public void testDeleteOnlyDomain() {
        GlobalDomainApi client = (GlobalDomainApi)this.requestSendsResponse(HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=deleteDomain&cleanup=false&id=1&apiKey=identity&signature=/5aLbigg612t9IrZi0JZO7CyiOU%3D")).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/deletedomainresponse.json"))).build());
        client.deleteOnlyDomain("1");
    }

    public void testDeleteDomainAndAttachedResources() {
        GlobalDomainApi client = (GlobalDomainApi)this.requestSendsResponse(HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=deleteDomain&cleanup=true&id=1&apiKey=identity&signature=grL7JStvtYUT89Jr0D8FgwMyJpU%3D")).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/deletedomainresponse.json"))).build());
        client.deleteDomainAndAttachedResources("1");
    }

    @Override
    protected GlobalDomainApi clientFrom(CloudStackContext context) {
        return context.getGlobalApi().getDomainClient();
    }
}

