/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import org.jclouds.cloudstack.CloudStackContext;
import org.jclouds.cloudstack.domain.AllocationState;
import org.jclouds.cloudstack.domain.NetworkType;
import org.jclouds.cloudstack.domain.Zone;
import org.jclouds.cloudstack.features.GlobalZoneApi;
import org.jclouds.cloudstack.internal.BaseCloudStackExpectTest;
import org.jclouds.cloudstack.options.CreateZoneOptions;
import org.jclouds.cloudstack.options.UpdateZoneOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="GlobalZoneApiExpectTest")
public class GlobalZoneApiExpectTest
extends BaseCloudStackExpectTest<GlobalZoneApi> {
    HttpRequest createZone = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"createZone"}).addQueryParam("name", new String[]{"test-zone"}).addQueryParam("networktype", new String[]{"Basic"}).addQueryParam("dns1", new String[]{"8.8.8.8"}).addQueryParam("internaldns1", new String[]{"10.10.10.10"}).addQueryParam("apiKey", new String[]{"identity"}).addQueryParam("signature", new String[]{"hWNmM2+Tsfb5DelQa/GJLN5DVWE="}).addHeader("Accept", new String[]{"application/json"})).build();

    public void testCreateZoneWhenResponseIs2xxAnd404() {
        GlobalZoneApi client = (GlobalZoneApi)this.requestSendsResponse(this.createZone, ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/createzoneresponse.json"))).build());
        Assert.assertEquals((Object)client.createZone("test-zone", NetworkType.BASIC, "8.8.8.8", "10.10.10.10", new CreateZoneOptions[0]), (Object)Zone.builder().id("6").name("test-zone").DNS((List)ImmutableList.of((Object)"8.8.8.8")).internalDNS((List)ImmutableList.of((Object)"10.10.10.10")).networkType(NetworkType.BASIC).securityGroupsEnabled(true).allocationState(AllocationState.ENABLED).zoneToken("7b6e27df-30a6-3024-9d8b-7971a3127f64").dhcpProvider("DhcpServer").build());
        client = (GlobalZoneApi)this.requestSendsResponse(this.createZone, HttpResponse.builder().statusCode(404).build());
        Assert.assertNull((Object)client.createZone("test-zone", NetworkType.BASIC, "8.8.8.8", "10.10.10.10", new CreateZoneOptions[0]));
    }

    public void testUpdateZoneWhenResponseIs2xxAnd404() {
        HttpRequest request = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"updateZone"}).addQueryParam("id", new String[]{"6"}).addQueryParam("name", new String[]{"test-zone"}).addQueryParam("dns1", new String[]{"8.8.8.8"}).addQueryParam("apiKey", new String[]{"identity"}).addQueryParam("signature", new String[]{"v19FdHKHztdT0IRloYFFn0eNbWM="}).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"application/json").build())).build();
        GlobalZoneApi client = (GlobalZoneApi)this.requestSendsResponse(request, ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/updatezoneresponse.json"))).build());
        Assert.assertEquals((Object)client.updateZone("6", new UpdateZoneOptions[]{UpdateZoneOptions.Builder.name((String)"test-zone").externalDns((List)ImmutableList.of((Object)"8.8.8.8"))}), (Object)Zone.builder().id("6").name("test-zone").DNS((List)ImmutableList.of((Object)"8.8.8.8")).internalDNS((List)ImmutableList.of((Object)"10.10.10.10")).networkType(NetworkType.BASIC).securityGroupsEnabled(true).allocationState(AllocationState.ENABLED).zoneToken("7b6e27df-30a6-3024-9d8b-7971a3127f64").dhcpProvider("DhcpServer").build());
        client = (GlobalZoneApi)this.requestSendsResponse(request, HttpResponse.builder().statusCode(404).build());
        Assert.assertNull((Object)client.updateZone("6", new UpdateZoneOptions[]{UpdateZoneOptions.Builder.name((String)"test-zone").externalDns((List)ImmutableList.of((Object)"8.8.8.8"))}));
    }

    public void testDeleteZone() {
        GlobalZoneApi client = (GlobalZoneApi)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"deleteZone"}).addQueryParam("id", new String[]{"6"}).addQueryParam("apiKey", new String[]{"identity"}).addQueryParam("signature", new String[]{"TfkzSIK8kzGJnIYo3DofECyuOII="}).addHeader("Accept", new String[]{"application/json"})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/deletezoneresponse.json"))).build());
        client.deleteZone("6");
    }

    @Override
    protected GlobalZoneApi clientFrom(CloudStackContext context) {
        return context.getGlobalApi().getZoneApi();
    }
}

