/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.jclouds.cloudstack.domain.NetworkType;
import org.jclouds.cloudstack.domain.Zone;
import org.jclouds.cloudstack.internal.BaseCloudStackApiLiveTest;
import org.jclouds.cloudstack.options.CreateZoneOptions;
import org.jclouds.cloudstack.options.UpdateZoneOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="GlobalZoneApiLiveTest")
public class GlobalZoneApiLiveTest
extends BaseCloudStackApiLiveTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateUpdateDeleteZone() {
        this.skipIfNotGlobalAdmin();
        Zone zone = null;
        String zoneName = this.prefix + "-zone";
        try {
            zone = this.globalAdminClient.getZoneApi().createZone(zoneName, NetworkType.BASIC, "8.8.8.8", "10.10.10.10", new CreateZoneOptions[0]);
            Assert.assertNotNull((Object)zone);
            Assert.assertEquals((Object)zone, (Object)this.globalAdminClient.getZoneApi().getZone(zone.getId()));
            Assert.assertEquals((Object)zone.getNetworkType(), (Object)NetworkType.BASIC);
            Assert.assertEquals((Collection)zone.getDNS(), (Collection)ImmutableList.of((Object)"8.8.8.8"));
            Assert.assertEquals((Collection)zone.getInternalDNS(), (Collection)ImmutableList.of((Object)"10.10.10.10"));
            Zone updated = this.globalAdminClient.getZoneApi().updateZone(zone.getId(), new UpdateZoneOptions[]{UpdateZoneOptions.Builder.name((String)(zoneName + "-2")).externalDns((List)ImmutableList.of((Object)"8.8.4.4"))});
            Assert.assertEquals((String)updated.getId(), (String)zone.getId());
            Assert.assertEquals((Collection)updated.getDNS(), (Collection)ImmutableList.of((Object)"8.8.4.4"));
        }
        finally {
            if (zone != null) {
                this.globalAdminClient.getZoneApi().deleteZone(zone.getId());
            }
        }
    }
}

