/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.collect.Iterables;
import java.util.Set;
import org.jclouds.cloudstack.domain.IPForwardingRule;
import org.jclouds.cloudstack.internal.BaseCloudStackApiLiveTest;
import org.jclouds.cloudstack.options.ListIPForwardingRulesOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="NATApiLiveTest")
public class NATApiLiveTest
extends BaseCloudStackApiLiveTest {
    @Test(enabled=false)
    public void testListIPForwardingRules() throws Exception {
        Set response = this.client.getNATApi().listIPForwardingRules(new ListIPForwardingRulesOptions[0]);
        assert (null != response);
        Assert.assertTrue((response.size() > 0 ? 1 : 0) != 0);
        for (IPForwardingRule rule : response) {
            IPForwardingRule newDetails = (IPForwardingRule)Iterables.getOnlyElement((Iterable)this.client.getNATApi().listIPForwardingRules(new ListIPForwardingRulesOptions[]{ListIPForwardingRulesOptions.Builder.id((String)rule.getId())}));
            Assert.assertEquals((String)rule.getId(), (String)newDetails.getId());
            this.checkRule(rule);
        }
    }

    protected void checkRule(IPForwardingRule rule) {
        Assert.assertEquals((String)rule.getId(), (String)this.client.getNATApi().getIPForwardingRule(rule.getId()).getId());
        assert (rule.getId() != null) : rule;
        assert (rule.getIPAddress() != null) : rule;
        assert (rule.getIPAddressId() != null) : rule;
        assert (rule.getStartPort() > 0) : rule;
        assert (rule.getProtocol() != null) : rule;
        assert (rule.getEndPort() > 0) : rule;
        assert (rule.getState() != null) : rule;
        assert (rule.getVirtualMachineId() != null) : rule;
        assert (rule.getVirtualMachineName() != null) : rule;
    }
}

